
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `account_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` bigint(20) unsigned DEFAULT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `affects_gross` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `account_groups_name_unique` (`name`),
  UNIQUE KEY `account_groups_code_unique` (`code`),
  KEY `account_groups_created_by_foreign` (`created_by`),
  KEY `account_groups_updated_by_foreign` (`updated_by`),
  CONSTRAINT `account_groups_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `account_groups_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_groups` WRITE;
/*!40000 ALTER TABLE `account_groups` DISABLE KEYS */;
INSERT INTO `account_groups` VALUES (1,NULL,1,NULL,'Assets',NULL,0,'2020-02-14 17:52:54',NULL),(2,NULL,1,NULL,'Liabilities and Owners Equity',NULL,0,'2020-02-14 17:52:54',NULL),(3,NULL,1,NULL,'Incomes',NULL,0,'2020-02-14 17:52:54',NULL),(4,NULL,1,NULL,'Expenses',NULL,0,'2020-02-14 17:52:54',NULL),(5,1,1,NULL,'Fixed Assets',NULL,0,'2020-02-14 17:52:54',NULL),(6,1,1,NULL,'Current Assets',NULL,0,'2020-02-14 17:52:54',NULL),(7,1,1,NULL,'Investments',NULL,0,'2020-02-14 17:52:54',NULL),(8,2,1,NULL,'Capital Account',NULL,0,'2020-02-14 17:52:54',NULL),(9,2,1,NULL,'Current Liabilities',NULL,0,'2020-02-14 17:52:54',NULL),(10,2,1,NULL,'Loans (Liabilities)',NULL,0,'2020-02-14 17:52:54',NULL),(11,3,1,NULL,'Direct Incomes',NULL,1,'2020-02-14 17:52:54',NULL),(12,4,1,NULL,'Direct Expenses',NULL,1,'2020-02-14 17:52:54',NULL),(13,3,1,NULL,'Indirect Incomes',NULL,0,'2020-02-14 17:52:54',NULL),(14,4,1,NULL,'Indirect Expenses',NULL,0,'2020-02-14 17:52:54',NULL),(15,3,1,NULL,'Sales',NULL,0,'2020-02-14 17:52:54',NULL),(16,4,1,NULL,'Purchases',NULL,0,'2020-02-14 17:52:54',NULL),(17,12,1,NULL,'Salary & Wages',NULL,1,'2020-02-14 17:52:54',NULL),(18,16,1,NULL,'Die',NULL,0,'2020-02-14 17:52:54',NULL),(19,16,1,NULL,'Punch',NULL,0,'2020-02-14 17:52:54',NULL),(20,16,1,NULL,'Patti',NULL,0,'2020-02-14 17:52:54',NULL),(21,16,1,NULL,'Binder & Chemical',NULL,0,'2020-02-14 17:52:54',NULL),(22,16,1,NULL,'Metal Powder',NULL,0,'2020-02-14 17:52:54',NULL),(23,16,1,NULL,'Diamond Powder',NULL,0,'2020-02-14 17:52:54',NULL),(24,16,1,NULL,'Machine Accessories',NULL,0,'2020-02-14 17:52:54',NULL);
/*!40000 ALTER TABLE `account_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `account_total_view`;
/*!50001 DROP VIEW IF EXISTS `account_total_view`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE VIEW `account_total_view` AS SELECT 
 1 AS `account_id`,
 1 AS `group_id`,
 1 AS `name`,
 1 AS `account_group`,
 1 AS `tr_date`,
 1 AS `month`,
 1 AS `cr_total`,
 1 AS `dr_total`*/;
SET character_set_client = @saved_cs_client;
DROP TABLE IF EXISTS `account_view`;
/*!50001 DROP VIEW IF EXISTS `account_view`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE VIEW `account_view` AS SELECT 
 1 AS `name`,
 1 AS `account_id`,
 1 AS `account_group`,
 1 AS `group_id`,
 1 AS `tr_date`,
 1 AS `month`,
 1 AS `entrytype`,
 1 AS `invoice_ref_id`,
 1 AS `cr_total`,
 1 AS `dr_total`,
 1 AS `narration`,
 1 AS `entry_id`,
 1 AS `yearmonthindex`,
 1 AS `op_balance_cr`,
 1 AS `op_balance_dr`*/;
SET character_set_client = @saved_cs_client;
DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `balance_cr` decimal(25,2) NOT NULL DEFAULT '0.00',
  `balance_dr` decimal(25,2) NOT NULL DEFAULT '0.00',
  `type` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `reconciliation` tinyint(1) NOT NULL DEFAULT '0',
  `phoneNo` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gstNo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `billing_address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `accounts_name_unique` (`name`),
  KEY `accounts_group_id_foreign` (`group_id`),
  KEY `accounts_created_by_foreign` (`created_by`),
  KEY `accounts_updated_by_foreign` (`updated_by`),
  CONSTRAINT `accounts_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `accounts_group_id_foreign` FOREIGN KEY (`group_id`) REFERENCES `account_groups` (`id`),
  CONSTRAINT `accounts_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=69 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (9,15,'Salasar Granite Ind',0.00,0.00,'0',1,NULL,'S.PAREEK0874@GMAIL.COM','08ACHFS6434M1ZK',NULL,NULL,3,NULL,'2020-02-22 05:38:07','2020-02-22 05:38:07',NULL),(10,15,'Prerna Landcon pvt.ltd',0.00,0.00,'1',0,NULL,NULL,'08AADCP9656R1ZD','RiICO IND AREA RAJSAMAND',NULL,3,NULL,'2020-02-23 00:28:51','2020-02-23 00:28:51',NULL),(11,15,'Rajputana granite pvt.ltd',0.00,0.00,'1',0,NULL,NULL,'08AABCR0447G1ZL','TASOL ROAD PASSUND RAJSAMAND',NULL,3,NULL,'2020-02-23 00:31:40','2020-02-23 00:31:40',NULL),(12,15,'Balaji Stone Mart Pvt.Ltd',0.00,0.00,'1',0,NULL,NULL,'08AAFCB1596C1ZT','RIICO AREA DHOINDA RAJSAMAND',NULL,3,NULL,'2020-02-23 00:33:39','2020-02-23 00:33:39',NULL),(13,15,'Shree Shyam Granite',0.00,0.00,'1',0,NULL,NULL,'08ACIF5679M1Z6','MERDA ROAD  RAJSAMAND',NULL,3,NULL,'2020-02-23 00:35:30','2020-02-23 00:35:30',NULL),(14,15,'Asocited Marmo & Granite Pvt Ltd',0.00,0.00,'1',0,NULL,NULL,'08AACCA728561ZY','PASSOND  RAJSAMAND',NULL,3,NULL,'2020-02-23 00:38:02','2020-02-23 00:38:02',NULL),(15,15,'Satynarayan Marble Pvt.Ltd',0.00,0.00,'1',0,NULL,NULL,'08AAFCS5548D1ZA','PASSOND  RAJSAMAND',NULL,3,NULL,'2020-02-23 00:39:38','2020-02-23 00:39:38',NULL),(16,15,'Z And D Diamands',0.00,0.00,'1',0,NULL,NULL,'08DHHPM3553B1ZH','KANKROLI RAJSAMAND',NULL,3,NULL,'2020-02-23 00:41:40','2020-02-23 00:41:40',NULL),(17,15,'Shiv Shakti Marble Supplier',0.00,0.00,'1',0,NULL,NULL,'08ADTPG8892Q1Z7','RAJNAGER RAJSAMAND',NULL,3,NULL,'2020-02-23 00:43:52','2020-02-23 00:43:52',NULL),(18,15,'Raj Rajeshwari Marble',0.00,0.00,'1',0,NULL,NULL,'08AAYPB9818R1ZJ','TASOL ROAD PASSOND RAJSAMAND',NULL,3,NULL,'2020-02-23 00:45:32','2020-02-23 00:45:32',NULL),(19,15,'Thakur Marble Pvt Ltd',0.00,0.00,'1',0,NULL,NULL,'08AABCT5205A1ZX','TASOL ROAD PASSOND RAJSAMAND',NULL,3,NULL,'2020-02-23 00:46:49','2020-02-23 00:46:49',NULL),(20,15,'Shree Khandal Mata ji Pvt Ltd',0.00,0.00,'0',0,NULL,NULL,'08AAIC56701M1ZZ','PASSOND RAJSAMAND',NULL,3,3,'2020-02-23 00:48:15','2020-02-23 18:05:33',NULL),(21,15,'Shri Bala Ji White Marmo Stones Pvt Ltd',0.00,0.00,'1',0,NULL,NULL,'08AAHCS6029H1Z6','PASSOND RAJSAMAND',NULL,3,NULL,'2020-02-23 00:50:07','2020-02-23 00:50:07',NULL),(22,15,'Shiv Bhole Dia Tools',0.00,0.00,'1',0,NULL,NULL,'08AURPM4999H1ZN','KANKROLI RAJSAMAND',NULL,3,NULL,'2020-02-23 00:52:01','2020-02-23 00:52:01',NULL),(23,15,'Synergy India Diamond',0.00,0.00,'1',0,NULL,NULL,'08ACIF9632E1ZU','DIDWANA NAGAUR TOOLS',NULL,3,NULL,'2020-02-23 00:54:52','2020-02-23 00:54:52',NULL),(24,15,'Saraswati Marble & Granite Ind pvt Ltd',0.00,0.00,'1',0,NULL,NULL,'08AAACS1104Q1ZC','PASSOND RAJSAMAND',NULL,3,NULL,'2020-02-23 00:57:06','2020-02-23 00:57:06',NULL),(25,15,'Mahesh Granite',0.00,0.00,'1',0,NULL,NULL,'08AAXFM4323K1ZQ','RIICO AREYA DHOINDA RAJSAMAND',NULL,3,3,'2020-02-23 00:58:08','2020-02-23 17:35:46',NULL),(26,19,'A N Creations',0.00,0.00,'0',0,NULL,NULL,'08ABMFA8592N1ZI','SODALA JAIPUR',NULL,3,3,'2020-02-23 01:06:52','2020-02-23 18:10:55',NULL),(27,22,'Mittal Industries',0.00,0.00,'1',0,NULL,NULL,'08AFNPM7491R1Z8','SITAPURA  JAIPUR',NULL,3,NULL,'2020-02-23 01:10:50','2020-02-23 01:10:50',NULL),(28,22,'Crown Ferro Alloys Pvt Ltd',0.00,0.00,'1',0,NULL,NULL,'24AAACC7672B1Z0','MAKARPURA VADODARA',NULL,3,NULL,'2020-02-23 01:20:02','2020-02-23 01:20:02',NULL),(29,22,'Sarda Industrial Enterprised',0.00,0.00,'1',0,NULL,NULL,'24AATAS3741A1ZF','JAIPUR',NULL,3,NULL,'2020-02-23 01:21:46','2020-02-23 01:21:46',NULL),(30,23,'Dhvani Marketing Services',0.00,0.00,'0',0,NULL,NULL,'27AACFD5282H1ZF','MUMBAI',NULL,3,1,'2020-02-23 01:24:18','2020-02-26 05:24:44',NULL),(31,23,'SHANTI UDYOG',0.00,0.00,'0',0,NULL,NULL,'08AADPG9287E1ZJ','JAIPUR',NULL,3,NULL,'2020-02-23 01:25:55','2020-02-23 01:25:55',NULL),(32,23,'VIVEK AGENCIES',0.00,0.00,'0',0,NULL,NULL,'27AACFV3899E1ZS','MUMBAI',NULL,3,NULL,'2020-02-23 01:28:10','2020-02-23 01:28:10',NULL),(33,15,'KAMAL JI',2700.00,0.00,'0',0,NULL,NULL,NULL,'RAJSAMAND',NULL,3,NULL,'2020-02-23 01:30:58','2020-02-23 01:30:58',NULL),(34,15,'JAGDISH JI FACTORY',49600.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,NULL,'2020-02-23 01:37:36','2020-02-23 01:37:36',NULL),(35,15,'SIHODI MARBLE',0.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,NULL,'2020-02-23 01:38:34','2020-02-23 01:38:34',NULL),(36,15,'SHREE LAHARI LAL JI MORCHANA',0.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,NULL,'2020-02-23 01:39:24','2020-02-23 01:39:24',NULL),(37,15,'ANAND TRADING COMPANY',0.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,NULL,'2020-02-23 01:39:45','2020-02-23 01:39:45',NULL),(38,15,'kishan luhar amit road',0.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,NULL,'2020-02-23 01:40:43','2020-02-23 01:40:43',NULL),(39,15,'ASHOK JI BOHARA MORCHANA',0.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,1,1,'2020-02-23 01:42:03','2020-02-23 01:51:46',NULL),(40,15,'SHREE MAHASH JI SHRIMALI',76800.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,NULL,'2020-02-23 01:44:34','2020-02-23 01:44:34',NULL),(41,15,'LAXMAN JI DALPAT JI',0.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,NULL,'2020-02-23 01:46:35','2020-02-23 01:46:35',NULL),(42,15,'SHREE MALIKA ARJUN MARBLE',17464.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,NULL,'2020-02-23 01:47:32','2020-02-23 01:47:32',NULL),(43,15,'SHREE KANIYA LAL JI',1100.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,NULL,'2020-02-23 01:48:30','2020-02-23 01:48:30',NULL),(44,15,'SHREE SAMDHANI MARBLE',0.00,0.00,'0',0,NULL,NULL,NULL,'AMET ROAD',NULL,3,NULL,'2020-02-23 01:49:44','2020-02-23 01:49:44',NULL),(45,15,'MANTRI MARBLE PVT LTD',0.00,0.00,'0',0,NULL,NULL,NULL,'TASOOL  ROAD',NULL,3,NULL,'2020-02-23 01:50:32','2020-02-23 01:50:32',NULL),(46,15,'S R MARBLE AAGRIYA',0.00,0.00,'0',0,NULL,NULL,NULL,'AGRIYA',NULL,3,NULL,'2020-02-23 01:51:30','2020-02-23 01:51:30',NULL),(47,15,'PROGRESHIVE GRANITE MOHI',6500.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,NULL,'2020-02-23 17:36:42','2020-02-23 17:36:42',NULL),(48,15,'MHARAJ SHANTINATH',23400.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,NULL,'2020-02-23 18:02:04','2020-02-23 18:02:04',NULL),(49,15,'BHAWAR JI AMIT ROAD',5400.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,NULL,'2020-02-23 18:06:41','2020-02-23 18:06:41',NULL),(50,15,'ALANKAR MARBLE',48000.00,0.00,'0',0,NULL,NULL,NULL,'MHOKHAMPURA',NULL,3,NULL,'2020-02-23 18:08:15','2020-02-23 18:08:15',NULL),(51,15,'papu ji brazing riico',2700.00,0.00,'0',0,NULL,NULL,NULL,'RIICO BRAZING CENTER',NULL,3,NULL,'2020-02-23 18:09:24','2020-02-23 18:09:24',NULL),(52,15,'KAMAL MARBLE',46200.00,0.00,'0',0,NULL,NULL,NULL,'PASSUND RAJSAMAND',NULL,3,NULL,'2020-02-23 18:12:09','2020-02-23 18:12:09',NULL),(53,15,'SHREE CHARBHUJA GRANITE',0.00,41500.00,'0',0,NULL,NULL,NULL,'KELWA JETPURA',NULL,3,3,'2020-02-23 18:13:51','2020-03-06 17:57:05',NULL),(54,15,'B N MARBLE',14160.00,0.00,'0',0,NULL,NULL,NULL,'MOKHAMPURA',NULL,3,NULL,'2020-02-23 18:15:26','2020-02-23 18:15:26',NULL),(55,15,'N M MARBLE',44000.00,0.00,'0',0,NULL,NULL,NULL,'UDAIPUR',NULL,3,NULL,'2020-02-23 18:16:42','2020-02-23 18:16:42',NULL),(56,15,'SHIVA MARBLE',39380.00,0.00,'0',0,NULL,NULL,NULL,'PASSUND',NULL,3,NULL,'2020-02-23 18:19:32','2020-02-23 18:19:32',NULL),(57,15,'NATURAL MARBLE',66000.00,0.00,'0',0,NULL,NULL,NULL,'AMET ROAD',NULL,3,NULL,'2020-02-23 18:23:28','2020-02-23 18:23:28',NULL),(58,15,'NATRAJ MARBLE',30000.00,0.00,'0',0,NULL,NULL,NULL,'AMET ROAD',NULL,3,NULL,'2020-02-23 18:24:34','2020-02-23 18:24:34',NULL),(59,15,'bhawani marble',30000.00,0.00,'0',0,NULL,NULL,NULL,'TASOOL ROAD',NULL,3,NULL,'2020-02-23 18:25:25','2020-02-23 18:25:25',NULL),(60,6,'Cash Account',0.00,0.00,'1',0,NULL,NULL,NULL,NULL,NULL,3,NULL,'2020-02-23 18:31:24','2020-02-23 18:31:24',NULL),(61,6,'Amar Axis Bank',0.00,0.00,'1',0,NULL,NULL,NULL,NULL,NULL,3,1,'2020-02-23 18:31:50','2020-03-01 12:45:44',NULL),(62,19,'NICKUNJ EXIMP',23600.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,1,'2020-02-27 10:57:53','2020-02-27 12:14:16',NULL),(63,15,'shree kesariya ji marble',0.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,NULL,'2020-03-01 07:43:20','2020-03-01 07:43:20',NULL),(64,15,'JAGDISH JI GURJAR',15000.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,NULL,'2020-03-03 11:40:46','2020-03-03 11:40:46',NULL),(65,15,'vikas ji',0.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,NULL,'2020-03-04 06:53:31','2020-03-04 06:53:31',NULL),(66,15,'test sales account',0.00,2000.00,'0',0,NULL,NULL,NULL,NULL,NULL,1,1,'2020-03-05 02:10:01','2020-03-05 02:53:42',NULL),(67,19,'prem ji grefied',7210.00,0.00,'0',0,NULL,NULL,NULL,NULL,NULL,3,3,'2020-03-05 07:47:04','2020-03-05 07:49:57',NULL),(68,24,'NAKODA TRACTOR',0.00,0.00,'0',0,NULL,NULL,'08ABUPB6976F1Z5',NULL,NULL,3,NULL,'2020-03-06 05:42:50','2020-03-06 05:42:50',NULL);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bond_designs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bond_designs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size_specification` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size_print` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `weight1_lower` decimal(25,2) DEFAULT NULL,
  `weight1_upper` decimal(25,2) DEFAULT NULL,
  `weight1_nos` int(11) DEFAULT NULL,
  `weight2_lower` decimal(25,2) DEFAULT NULL,
  `weight2_upper` decimal(25,2) DEFAULT NULL,
  `weight2_nos` int(11) DEFAULT NULL,
  `weight1_average` decimal(25,2) DEFAULT NULL,
  `weight2_average` decimal(25,2) DEFAULT NULL,
  `weight1_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `weight2_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `consumable_setting_1` bigint(20) unsigned NOT NULL,
  `consumable_setting_2` bigint(20) unsigned DEFAULT NULL,
  `piece_net_weight` decimal(25,2) NOT NULL,
  `shape` enum('BOX-SHAPE','M-SHAPE','B-SHAPE','V-SHAPE') COLLATE utf8mb4_unicode_ci NOT NULL,
  `taper` decimal(25,2) NOT NULL DEFAULT '0.00',
  `width` decimal(25,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bond_designs_created_by_foreign` (`created_by`),
  KEY `bond_designs_updated_by_foreign` (`updated_by`),
  KEY `bond_designs_consumable_setting_1_foreign` (`consumable_setting_1`),
  KEY `bond_designs_consumable_setting_2_foreign` (`consumable_setting_2`),
  CONSTRAINT `bond_designs_consumable_setting_1_foreign` FOREIGN KEY (`consumable_setting_1`) REFERENCES `consumable_settings` (`id`),
  CONSTRAINT `bond_designs_consumable_setting_2_foreign` FOREIGN KEY (`consumable_setting_2`) REFERENCES `consumable_settings` (`id`),
  CONSTRAINT `bond_designs_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `bond_designs_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bond_designs` WRITE;
/*!40000 ALTER TABLE `bond_designs` DISABLE KEYS */;
INSERT INTO `bond_designs` VALUES (1,'Gangsaw-4.0-4.5mm','23/20X19X20mm','4.5mm',1.82,1.90,3,NULL,NULL,NULL,1.86,0.00,'Powder Patti Weight',NULL,25,NULL,5.58,'BOX-SHAPE',0.50,4.50,'2020-02-14 17:52:54','2020-03-05 03:58:07',1,1),(2,'Gangsaw-4.5-5.0mm','23/20X19X20mm','5.0mm',2.13,2.19,3,NULL,NULL,NULL,2.16,0.00,'Powder Patti Weight',NULL,25,NULL,6.48,'BOX-SHAPE',0.50,5.00,'2020-02-14 17:52:54','2020-03-05 03:58:29',1,1),(3,'Gangsaw-3.5-4.0mm','23/20X19X20mm','4.0mm',1.62,1.67,3,NULL,NULL,NULL,1.65,0.00,'Powder Patti Weight',NULL,25,NULL,4.94,'BOX-SHAPE',0.50,4.00,'2020-02-14 17:52:54','2020-03-05 03:58:19',1,1),(4,'Box-24X8.5mm','24X15X8.5mm','8.5mm',1.82,1.87,4,NULL,NULL,NULL,NULL,NULL,'Powder Patti Weight',NULL,26,NULL,7.20,'BOX-SHAPE',0.00,18.00,'2020-02-14 17:52:54',NULL,1,NULL),(5,'Box-23X8.5mm','23X15X8.5mm','8.5mm',1.82,1.87,4,NULL,NULL,NULL,NULL,NULL,'Powder Patti Weight',NULL,26,NULL,7.20,'BOX-SHAPE',0.00,18.00,'2020-02-14 17:52:54',NULL,1,NULL),(6,'MShape-8.5mm','24X15X7.5/8.5mm','8.5mm',1.82,1.87,4,NULL,NULL,NULL,NULL,NULL,'Powder Patti Weight',NULL,26,NULL,7.20,'M-SHAPE',0.50,18.00,'2020-02-14 17:52:54',NULL,1,NULL),(7,'MShape-10.5mm','24X15X9.5/10.5mm','8.5mm',1.82,1.87,4,NULL,NULL,NULL,NULL,NULL,'Powder Patti Weight',NULL,26,NULL,7.20,'M-SHAPE',0.50,18.00,'2020-02-14 17:52:54',NULL,1,NULL);
/*!40000 ALTER TABLE `bond_designs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bond_invoice_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bond_invoice_detail` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint(20) unsigned NOT NULL,
  `packing_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `unit_price` decimal(25,2) DEFAULT NULL,
  `amount` decimal(25,2) DEFAULT NULL,
  `cgst` decimal(25,2) DEFAULT '0.00',
  `sgst` decimal(25,2) DEFAULT '0.00',
  `igst` decimal(25,2) DEFAULT '0.00',
  `cgst_value` decimal(25,2) DEFAULT '0.00',
  `sgst_value` decimal(25,2) DEFAULT '0.00',
  `igst_value` decimal(25,2) DEFAULT '0.00',
  `net_gst` decimal(25,2) DEFAULT '0.00',
  `discount` decimal(25,2) DEFAULT '0.00',
  `discount_val` decimal(25,2) DEFAULT '0.00',
  `net_amount` decimal(25,2) DEFAULT '0.00',
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `bond_invoice_detail_packing_id_unique` (`packing_id`),
  KEY `bond_invoice_detail_invoice_id_foreign` (`invoice_id`),
  KEY `bond_invoice_detail_created_by_foreign` (`created_by`),
  KEY `bond_invoice_detail_updated_by_foreign` (`updated_by`),
  CONSTRAINT `bond_invoice_detail_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `bond_invoice_detail_invoice_id_foreign` FOREIGN KEY (`invoice_id`) REFERENCES `invoices` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bond_invoice_detail_packing_id_foreign` FOREIGN KEY (`packing_id`) REFERENCES `production_packagings` (`packing_id`),
  CONSTRAINT `bond_invoice_detail_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bond_invoice_detail` WRITE;
/*!40000 ALTER TABLE `bond_invoice_detail` DISABLE KEYS */;
INSERT INTO `bond_invoice_detail` VALUES (3,22,789674,'2020-03-03 12:17:21',NULL,27.78,2500.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,2500.00,3,NULL),(4,23,413777,'2020-03-04 06:58:18',NULL,22.00,22000.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,22000.00,3,NULL),(5,24,909225,'2020-03-04 07:11:25',NULL,25.00,34000.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,34000.00,3,NULL),(6,25,393094,'2020-03-04 07:13:37',NULL,22.00,22000.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,22000.00,3,NULL),(7,28,692492,'2020-03-04 10:44:23',NULL,40.00,40000.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,40000.00,3,NULL);
/*!40000 ALTER TABLE `bond_invoice_detail` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bond_material_recipes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bond_material_recipes` (
  `material_id` bigint(20) unsigned NOT NULL,
  `bond_product_id` bigint(20) unsigned NOT NULL,
  `bond_process_id` bigint(20) unsigned NOT NULL,
  `weight` decimal(25,2) NOT NULL DEFAULT '0.00',
  `powder_cost` decimal(25,2) NOT NULL DEFAULT '0.00',
  `packing_settings_id` bigint(20) unsigned NOT NULL,
  `finishing_settings_id` bigint(20) unsigned NOT NULL,
  `total_piece_packing` decimal(25,2) DEFAULT '0.00',
  `priority` enum('NORMAL','MEDIUM','HIGH','URGENT') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'NORMAL',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`material_id`),
  UNIQUE KEY `bond_material_recipes_material_id_unique` (`material_id`),
  KEY `bond_material_recipes_bond_process_id_foreign` (`bond_process_id`),
  KEY `bond_material_recipes_created_by_foreign` (`created_by`),
  KEY `bond_material_recipes_updated_by_foreign` (`updated_by`),
  KEY `bond_material_recipes_packing_settings_id_foreign` (`packing_settings_id`),
  KEY `bond_material_recipes_finishing_settings_id_foreign` (`finishing_settings_id`),
  KEY `bond_material_recipes_bond_product_id_foreign` (`bond_product_id`),
  CONSTRAINT `bond_material_recipes_bond_process_id_foreign` FOREIGN KEY (`bond_process_id`) REFERENCES `bond_process_params` (`id`),
  CONSTRAINT `bond_material_recipes_bond_product_id_foreign` FOREIGN KEY (`bond_product_id`) REFERENCES `bond_products` (`id`),
  CONSTRAINT `bond_material_recipes_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `bond_material_recipes_finishing_settings_id_foreign` FOREIGN KEY (`finishing_settings_id`) REFERENCES `consumable_settings` (`id`),
  CONSTRAINT `bond_material_recipes_packing_settings_id_foreign` FOREIGN KEY (`packing_settings_id`) REFERENCES `consumable_settings` (`id`),
  CONSTRAINT `bond_material_recipes_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bond_material_recipes` WRITE;
/*!40000 ALTER TABLE `bond_material_recipes` DISABLE KEYS */;
INSERT INTO `bond_material_recipes` VALUES (14002,4,1,12872.00,1.00,16,23,2000.00,'URGENT','2020-02-24 02:02:02','2020-02-26 08:38:32',1,1),(21038,5,1,22596.00,1.00,16,23,3500.00,'NORMAL','2020-03-05 06:47:37','2020-03-06 03:21:27',3,3),(27544,5,1,12112.00,1.00,16,23,2000.00,'URGENT','2020-02-26 01:53:51','2020-02-26 01:53:51',3,NULL),(41430,7,1,9075.00,1.00,16,23,1000.00,'MEDIUM','2020-02-27 01:49:40','2020-02-27 01:49:40',3,NULL),(47386,3,1,9654.00,1.00,15,23,1500.00,'URGENT','2020-02-24 02:03:35','2020-02-24 02:03:35',3,NULL),(51070,1,1,35398.00,1.00,16,23,5500.00,'NORMAL','2020-03-03 02:27:25','2020-03-05 06:46:24',3,3),(66066,6,1,12112.00,1.00,16,22,2000.00,'MEDIUM','2020-02-28 03:09:31','2020-02-28 03:09:31',3,NULL),(74246,11,2,33308.00,1.00,17,23,2600.00,'NORMAL','2020-02-28 08:43:09','2020-02-28 08:43:09',3,NULL),(78279,5,1,12112.00,1.00,15,23,2000.00,'NORMAL','2020-03-01 01:00:42','2020-03-01 01:00:42',3,NULL),(79748,5,1,12.00,1.00,16,23,2000.00,'NORMAL','2020-03-07 01:15:04','2020-03-07 01:15:04',3,NULL),(80675,5,1,12112.00,1.00,16,22,2000.00,'NORMAL','2020-02-28 15:33:12','2020-02-28 15:33:12',3,NULL),(85759,1,1,12872.00,1.00,15,23,2000.00,'URGENT','2020-02-25 01:34:12','2020-02-25 01:34:12',3,NULL);
/*!40000 ALTER TABLE `bond_material_recipes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bond_process_consumable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bond_process_consumable` (
  `bond_process_id` bigint(20) unsigned NOT NULL,
  `consumable_settings_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`bond_process_id`,`consumable_settings_id`),
  KEY `consumable_settings_foreign` (`consumable_settings_id`),
  CONSTRAINT `bond_process_params_foreign` FOREIGN KEY (`bond_process_id`) REFERENCES `bond_process_params` (`id`) ON DELETE CASCADE,
  CONSTRAINT `consumable_settings_foreign` FOREIGN KEY (`consumable_settings_id`) REFERENCES `consumable_settings` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bond_process_consumable` WRITE;
/*!40000 ALTER TABLE `bond_process_consumable` DISABLE KEYS */;
INSERT INTO `bond_process_consumable` VALUES (1,1,'2020-02-15 18:14:04',NULL),(1,5,'2020-02-15 18:14:04',NULL),(1,7,'2020-02-15 18:14:04',NULL),(1,15,'2020-02-15 18:14:04',NULL),(2,2,'2020-02-27 17:55:50',NULL),(2,6,'2020-02-27 17:55:50',NULL),(2,8,'2020-02-27 17:55:50',NULL),(2,12,'2020-02-27 17:55:50',NULL),(2,17,'2020-02-27 17:55:50',NULL);
/*!40000 ALTER TABLE `bond_process_consumable` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bond_process_params`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bond_process_params` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `proc_type` enum('SANDWITCH','WIRESAW_PEARL') COLLATE utf8mb4_unicode_ci NOT NULL,
  `mixing_detail` json DEFAULT NULL,
  `hotpress_detail` json DEFAULT NULL,
  `finishing_detail` json DEFAULT NULL,
  `other_detail` json DEFAULT NULL,
  `cycle_time` decimal(25,2) DEFAULT NULL,
  `expected_mould` decimal(25,2) DEFAULT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bond_process_params_created_by_foreign` (`created_by`),
  KEY `bond_process_params_updated_by_foreign` (`updated_by`),
  CONSTRAINT `bond_process_params_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `bond_process_params_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bond_process_params` WRITE;
/*!40000 ALTER TABLE `bond_process_params` DISABLE KEYS */;
INSERT INTO `bond_process_params` VALUES (1,'Gangsaw','SANDWITCH','{\"en\": \"mix\", \"hi\": \"mix\"}','{\"en\": \"hot\", \"hi\": \"hot\"}','{\"en\": \"finish\", \"hi\": \"finish\"}','{\"en\": \"other\", \"hi\": \"other\"}',13.00,4.00,1,NULL,'2020-02-15 18:14:04','2020-02-15 18:14:04'),(2,'BOX','SANDWITCH','{\"en\": \"mix powder for 3 hours\", \"hi\": \"3 घंटे के लिए पाउडर मिलाएं\"}','{\"en\": \"Use programme 1\", \"hi\": \"Use programme 1\"}','{\"en\": \"mix in tumbler for 45 minutes\", \"hi\": \"mix in tumbler for 45 minutes\"}','{\"en\": \"NA\", \"hi\": \"NA\"}',11.30,4.00,3,1,'2020-02-22 05:16:45','2020-02-27 17:55:50');
/*!40000 ALTER TABLE `bond_process_params` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bond_product_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bond_product_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `category` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name_print` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `bond_product_types_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bond_product_types` WRITE;
/*!40000 ALTER TABLE `bond_product_types` DISABLE KEYS */;
INSERT INTO `bond_product_types` VALUES (1,'Gangsaw','','','2020-02-14 17:52:54',NULL),(2,'Marble-Cutter','','','2020-02-14 17:52:54',NULL),(3,'Ganite-Cutter','','','2020-02-14 17:52:54',NULL),(4,'Mono Dressing','','','2020-02-14 17:52:54',NULL);
/*!40000 ALTER TABLE `bond_product_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bond_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bond_products` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name_print` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hsn_code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bond_id` bigint(20) unsigned NOT NULL,
  `bond_design_id` bigint(20) unsigned NOT NULL,
  `bond_type_id` bigint(20) unsigned NOT NULL,
  `opening_stock` decimal(25,2) NOT NULL DEFAULT '0.00',
  `qty_unit_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `bond_products_name_unique` (`name`),
  KEY `bond_products_qty_unit_id_foreign` (`qty_unit_id`),
  KEY `bond_products_bond_type_id_foreign` (`bond_type_id`),
  CONSTRAINT `bond_products_bond_type_id_foreign` FOREIGN KEY (`bond_type_id`) REFERENCES `bond_product_types` (`id`),
  CONSTRAINT `bond_products_qty_unit_id_foreign` FOREIGN KEY (`qty_unit_id`) REFERENCES `units` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bond_products` WRITE;
/*!40000 ALTER TABLE `bond_products` DISABLE KEYS */;
INSERT INTO `bond_products` VALUES (1,'G2 4.5mm','G2 4.5mm',NULL,1,1,1,2000.00,1,'2020-02-15 18:14:33','2020-02-15 18:14:33'),(3,'G2 4mm','G2 4mm',NULL,1,3,1,0.00,1,'2020-02-22 05:21:20','2020-02-22 05:21:20'),(4,'G3 4.5mm','G3 4.5mm',NULL,4,1,1,0.00,1,'2020-02-22 05:23:03','2020-02-22 05:23:03'),(5,'G51 4.5mm','G51 4.5mm',NULL,6,1,1,0.00,1,'2020-02-22 05:24:14','2020-02-22 05:24:14'),(6,'G22 4.5mm','G22 4.5mm',NULL,3,1,1,0.00,1,'2020-02-22 05:25:30','2020-02-22 05:25:30'),(7,'GPP','GPP',NULL,7,1,1,0.00,1,'2020-02-22 05:27:25','2020-02-22 05:27:25'),(8,'G21 4.5mm','G21 4.5mm',NULL,9,1,1,0.00,1,'2020-02-22 05:28:35','2020-02-22 05:28:35'),(9,'210 8.5mm','210 8.5mm',NULL,10,5,2,0.00,1,'2020-02-22 05:30:35','2020-02-22 05:30:35'),(10,'BOX 210 8.5mm','BOX 210 8.5',NULL,10,5,2,0.00,1,'2020-02-22 05:31:32','2020-02-22 05:31:32'),(11,'BOX 2210 8.5mm','BOX 2210 8.5mm',NULL,11,5,2,0.00,1,'2020-02-22 05:32:30','2020-02-22 05:32:30');
/*!40000 ALTER TABLE `bond_products` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bond_recipe_production_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bond_recipe_production_status` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `material_id` bigint(20) unsigned NOT NULL,
  `status_id` bigint(20) unsigned NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bond_recipe_production_status_material_id_foreign` (`material_id`),
  KEY `bond_recipe_production_status_status_id_foreign` (`status_id`),
  CONSTRAINT `bond_recipe_production_status_material_id_foreign` FOREIGN KEY (`material_id`) REFERENCES `bond_material_recipes` (`material_id`) ON DELETE CASCADE,
  CONSTRAINT `bond_recipe_production_status_status_id_foreign` FOREIGN KEY (`status_id`) REFERENCES `production_status` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bond_recipe_production_status` WRITE;
/*!40000 ALTER TABLE `bond_recipe_production_status` DISABLE KEYS */;
INSERT INTO `bond_recipe_production_status` VALUES (7,14002,1,3,'2020-02-24 02:02:02','2020-02-24 02:02:02'),(8,47386,1,3,'2020-02-24 02:03:35','2020-02-24 02:03:35'),(9,85759,1,3,'2020-02-25 01:34:12','2020-02-25 01:34:12'),(10,27544,1,3,'2020-02-26 01:53:51','2020-02-26 01:53:51'),(11,41430,1,3,'2020-02-27 01:49:40','2020-02-27 01:49:40'),(15,47386,4,1,'2020-02-27 18:08:02','2020-02-27 18:08:02'),(18,66066,1,3,'2020-02-28 03:09:31','2020-02-28 03:09:31'),(19,27544,2,3,'2020-02-28 08:39:46','2020-02-28 08:39:46'),(20,41430,2,3,'2020-02-28 08:40:28','2020-02-28 08:40:28'),(21,74246,1,3,'2020-02-28 08:43:09','2020-02-28 08:43:09'),(22,74246,2,3,'2020-02-28 08:46:11','2020-02-28 08:46:11'),(23,80675,1,3,'2020-02-28 15:33:12','2020-02-28 15:33:12'),(24,78279,1,3,'2020-03-01 01:00:42','2020-03-01 01:00:42'),(25,66066,2,3,'2020-03-01 06:10:45','2020-03-01 06:10:45'),(26,80675,2,2,'2020-03-01 11:44:23','2020-03-01 11:44:23'),(28,78279,2,2,'2020-03-02 11:44:29','2020-03-02 11:44:29'),(29,51070,1,3,'2020-03-03 02:27:25','2020-03-03 02:27:25'),(30,78279,2,1,'2020-03-05 02:54:17','2020-03-05 02:54:17'),(31,21038,1,3,'2020-03-05 06:47:37','2020-03-05 06:47:37'),(32,80675,4,1,'2020-03-05 09:17:20','2020-03-05 09:17:20'),(33,51070,2,2,'2020-03-05 11:44:29','2020-03-05 11:44:29'),(34,85759,2,1,'2020-03-05 17:44:53','2020-03-05 17:44:53'),(35,14002,2,1,'2020-03-05 17:45:19','2020-03-05 17:45:19'),(36,79748,1,3,'2020-03-07 01:15:04','2020-03-07 01:15:04');
/*!40000 ALTER TABLE `bond_recipe_production_status` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bond_recipe_productions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bond_recipe_productions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `material_id` bigint(20) unsigned NOT NULL,
  `start_time` datetime NOT NULL,
  `end_time` datetime NOT NULL,
  `duration` bigint(20) unsigned NOT NULL,
  `mould` decimal(25,2) NOT NULL,
  `remaining_piece` decimal(25,2) DEFAULT '0.00',
  `electricity_out_duration` bigint(20) DEFAULT '0',
  `other_prod_blocker_duration` bigint(20) DEFAULT '0',
  `other_blocker_reason` enum('RAW_MATERIAL_NOT_READY','RAW_MATERIAL_NOT_AVAILABLE','LESS_WORKER','OTHER') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reason` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `employee_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bond_recipe_productions_created_by_foreign` (`created_by`),
  KEY `bond_recipe_productions_updated_by_foreign` (`updated_by`),
  KEY `bond_recipe_productions_material_id_foreign` (`material_id`),
  KEY `bond_recipe_productions_employee_id_foreign` (`employee_id`),
  CONSTRAINT `bond_recipe_productions_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `bond_recipe_productions_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`),
  CONSTRAINT `bond_recipe_productions_material_id_foreign` FOREIGN KEY (`material_id`) REFERENCES `bond_material_recipes` (`material_id`),
  CONSTRAINT `bond_recipe_productions_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bond_recipe_productions` WRITE;
/*!40000 ALTER TABLE `bond_recipe_productions` DISABLE KEYS */;
INSERT INTO `bond_recipe_productions` VALUES (10,47386,'2020-02-25 06:10:00','2020-02-25 14:00:00',28200000,23.00,0.00,0,0,NULL,NULL,4,1,'2020-02-25 08:43:00','2020-02-25 15:49:27',NULL),(11,14002,'2020-02-22 14:10:00','2020-02-22 17:00:00',10200000,7.00,0.00,0,0,'OTHER',NULL,1,1,'2020-02-24 09:42:42','2020-02-26 08:35:50',NULL),(12,14002,'2020-02-24 06:00:00','2020-02-24 14:00:00',28800000,22.00,0.00,0,0,NULL,NULL,1,1,'2020-02-24 09:44:26','2020-02-25 17:50:47',NULL),(13,47386,'2020-02-26 06:10:00','2020-02-26 06:25:00',900000,1.00,0.00,0,0,NULL,NULL,1,NULL,'2020-02-26 12:06:32','2020-02-26 12:06:32',NULL),(14,85759,'2020-02-26 06:30:00','2020-02-26 14:00:00',27000000,22.00,0.00,0,0,NULL,NULL,1,NULL,'2020-02-26 12:07:35','2020-02-26 12:07:35',NULL),(15,85759,'2020-02-27 06:00:00','2020-02-27 09:00:00',10800000,9.00,0.00,0,0,NULL,NULL,2,1,'2020-02-27 08:33:11','2020-02-27 09:08:33',NULL),(16,27544,'2020-02-27 09:00:00','2020-02-27 14:00:00',18000000,13.00,0.00,0,0,NULL,NULL,2,NULL,'2020-02-27 08:34:42','2020-02-27 08:34:42',NULL),(23,27544,'2020-02-28 18:00:00','2020-02-28 23:00:00',18000000,14.00,0.00,10,0,NULL,NULL,3,1,'2020-02-28 08:39:46','2020-03-01 09:10:25',NULL),(24,41430,'2020-02-28 23:00:00','2020-02-28 14:00:00',32400000,8.00,0.00,0,0,NULL,NULL,3,NULL,'2020-02-28 08:40:28','2020-02-28 08:40:28',NULL),(25,74246,'2020-02-19 13:00:00','2020-02-19 14:00:00',3600000,4.00,0.00,0,0,NULL,NULL,3,NULL,'2020-02-28 08:46:11','2020-02-28 08:46:11',NULL),(26,74246,'2020-02-20 06:00:00','2020-02-20 14:00:00',28800000,42.00,0.00,0,0,NULL,NULL,3,NULL,'2020-02-28 08:46:50','2020-02-28 08:46:50',NULL),(27,74246,'2020-02-22 06:00:00','2020-02-22 11:00:00',18000000,16.00,0.00,0,0,NULL,NULL,3,NULL,'2020-02-28 08:47:54','2020-02-28 08:47:54',NULL),(28,41430,'2020-02-29 06:00:00','2020-02-29 11:35:00',20100000,12.00,0.00,0,0,NULL,NULL,3,3,'2020-03-01 06:06:00','2020-03-01 06:06:21',NULL),(29,66066,'2020-02-29 11:39:00','2020-02-29 14:00:00',8460000,10.00,0.00,0,0,NULL,NULL,3,NULL,'2020-03-01 06:10:45','2020-03-01 06:10:45',NULL),(31,66066,'2020-03-01 06:00:00','2020-03-01 12:40:00',24000000,19.00,0.00,0,0,NULL,NULL,2,NULL,'2020-03-01 11:42:24','2020-03-01 11:42:24',NULL),(32,80675,'2020-03-01 12:40:00','2020-03-01 14:10:00',5400000,4.00,0.00,0,0,NULL,NULL,2,NULL,'2020-03-01 11:44:23','2020-03-01 11:44:23',NULL),(33,80675,'2020-03-01 14:10:00','2020-03-01 17:00:00',10200000,8.00,0.00,0,0,NULL,NULL,2,NULL,'2020-03-01 11:45:53','2020-03-01 11:45:53',NULL),(34,80675,'2020-03-02 06:00:00','2020-03-02 12:10:00',22200000,17.00,0.00,0,0,NULL,NULL,2,NULL,'2020-03-02 11:37:40','2020-03-02 11:37:40',NULL),(35,78279,'2020-03-02 12:10:00','2020-03-02 14:01:00',6660000,5.00,0.00,0,0,NULL,NULL,2,NULL,'2020-03-02 11:44:29','2020-03-02 11:44:29',NULL),(36,78279,'2020-03-02 14:00:00','2020-03-02 17:00:00',10800000,8.00,0.00,0,0,NULL,NULL,2,NULL,'2020-03-02 11:45:43','2020-03-02 11:45:43',NULL),(37,78279,'2020-03-03 06:10:00','2020-03-03 06:40:00',1800000,2.00,0.00,0,0,NULL,NULL,2,NULL,'2020-03-03 09:06:39','2020-03-03 09:06:39',NULL),(38,78279,'2020-03-04 11:50:00','2020-03-04 17:00:00',18600000,15.00,0.00,30,0,NULL,NULL,2,NULL,'2020-03-04 11:43:29','2020-03-04 11:43:29',NULL),(39,51070,'2020-03-05 06:00:00','2020-03-05 14:00:00',28800000,23.00,0.00,0,0,NULL,NULL,2,NULL,'2020-03-05 11:44:29','2020-03-05 11:44:29',NULL),(40,51070,'2020-03-05 14:00:00','2020-03-05 17:00:00',10800000,8.00,0.00,0,0,NULL,NULL,2,1,'2020-03-05 11:45:40','2020-03-07 04:04:18',1),(41,51070,'2020-03-06 07:00:00','2020-03-06 14:00:00',25200000,22.00,0.00,0,0,NULL,NULL,2,1,'2020-03-06 08:25:48','2020-03-07 04:04:09',2),(42,51070,'2020-03-06 14:00:00','2020-03-06 17:01:00',10860000,9.00,0.00,0,0,NULL,NULL,2,1,'2020-03-06 11:33:19','2020-03-07 04:03:32',1);
/*!40000 ALTER TABLE `bond_recipe_productions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bonds`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bonds` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name_print` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `machine_type` enum('GANGSAW','DRESSING','MULTIBLADE_CUTTER','SINGLE_BLADE_CUTTER','WIRESAW_MACHINE','EDGE_CUTTING') COLLATE utf8mb4_unicode_ci NOT NULL,
  `stone_type` enum('MARBLE','SANDSTONE','GRANITE','TILES','IMPORTED_STONE') COLLATE utf8mb4_unicode_ci NOT NULL,
  `bond_short_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('ACTIVE','INACTIVE','DISCONTINUED') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'ACTIVE',
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bonds_created_by_foreign` (`created_by`),
  KEY `bonds_updated_by_foreign` (`updated_by`),
  CONSTRAINT `bonds_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `bonds_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bonds` WRITE;
/*!40000 ALTER TABLE `bonds` DISABLE KEYS */;
INSERT INTO `bonds` VALUES (1,'G2',NULL,'GANGSAW','MARBLE',NULL,'ACTIVE',1,NULL,'2020-02-15 18:13:08','2020-02-15 18:13:08'),(2,'G1',NULL,'GANGSAW','MARBLE',NULL,'ACTIVE',3,NULL,'2020-02-22 05:10:36','2020-02-22 05:10:36'),(3,'G22',NULL,'GANGSAW','MARBLE',NULL,'ACTIVE',3,NULL,'2020-02-22 05:11:00','2020-02-22 05:11:00'),(4,'G3',NULL,'GANGSAW','MARBLE',NULL,'ACTIVE',3,NULL,'2020-02-22 05:11:19','2020-02-22 05:11:19'),(5,'G3+',NULL,'GANGSAW','MARBLE',NULL,'ACTIVE',3,NULL,'2020-02-22 05:11:49','2020-02-22 05:11:49'),(6,'G51',NULL,'GANGSAW','MARBLE',NULL,'ACTIVE',3,NULL,'2020-02-22 05:12:09','2020-02-22 05:12:09'),(7,'GPP',NULL,'GANGSAW','MARBLE',NULL,'ACTIVE',3,NULL,'2020-02-22 05:12:49','2020-02-22 05:12:49'),(8,'G23',NULL,'GANGSAW','MARBLE',NULL,'ACTIVE',3,NULL,'2020-02-22 05:13:10','2020-02-22 05:13:10'),(9,'G21',NULL,'GANGSAW','MARBLE',NULL,'ACTIVE',3,NULL,'2020-02-22 05:13:37','2020-02-22 05:13:37'),(10,'210',NULL,'GANGSAW','MARBLE',NULL,'ACTIVE',3,NULL,'2020-02-22 05:14:13','2020-02-22 05:14:13'),(11,'2210',NULL,'GANGSAW','MARBLE',NULL,'ACTIVE',3,NULL,'2020-02-22 05:14:42','2020-02-22 05:14:42');
/*!40000 ALTER TABLE `bonds` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `company_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `company_detail` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tag_line` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  `gstNo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `web_address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone1` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone2` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone3` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email1` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email2` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_prefix` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_detail` text COLLATE utf8mb4_unicode_ci,
  `tnc` text COLLATE utf8mb4_unicode_ci,
  `logo_path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `watermark_path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `company_detail` WRITE;
/*!40000 ALTER TABLE `company_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `company_detail` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `consumable_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consumable_categories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` json NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `consumable_categories_created_by_foreign` (`created_by`),
  KEY `consumable_categories_updated_by_foreign` (`updated_by`),
  CONSTRAINT `consumable_categories_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `consumable_categories_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `consumable_categories` WRITE;
/*!40000 ALTER TABLE `consumable_categories` DISABLE KEYS */;
INSERT INTO `consumable_categories` VALUES (1,'2020-02-14 17:52:53',NULL,'{\"en\": \"Mould\", \"hi\": \"\"}',1,NULL),(2,'2020-02-14 17:52:53',NULL,'{\"en\": \"Iron Patti\", \"hi\": \"\"}',1,NULL),(3,'2020-02-14 17:52:53',NULL,'{\"en\": \"Chemical\", \"hi\": \"\"}',1,NULL),(4,'2020-02-14 17:52:53',NULL,'{\"en\": \"Grinding Wheel\", \"hi\": \"\"}',1,NULL),(5,'2020-02-14 17:52:53',NULL,'{\"en\": \"Binder\", \"hi\": \"\"}',1,NULL),(6,'2020-02-14 17:52:53',NULL,'{\"en\": \"Die\", \"hi\": \"\"}',1,NULL),(7,'2020-02-14 17:52:54',NULL,'{\"en\": \"Coldpress Accesories\", \"hi\": \"\"}',1,NULL),(8,'2020-02-14 17:52:54',NULL,'{\"en\": \"Hotpress Accesories\", \"hi\": \"\"}',1,NULL),(9,'2020-02-26 03:41:52','2020-02-26 03:41:52','{\"en\": \"Bond Materials\", \"hi\": \"Bond Materials\"}',1,NULL),(10,'2020-02-28 06:32:49','2020-02-28 06:32:49','{\"en\": \"Graphite Materials\", \"hi\": \"Graphite Materials\"}',1,NULL);
/*!40000 ALTER TABLE `consumable_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `consumable_consumpation_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consumable_consumpation_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `consumpation_id` bigint(20) unsigned NOT NULL,
  `consumable_id` bigint(20) unsigned NOT NULL,
  `qty` decimal(25,2) NOT NULL,
  `consumed_percentage` decimal(10,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `consumable_consumpation_details_created_by_foreign` (`created_by`),
  KEY `consumable_consumpation_details_updated_by_foreign` (`updated_by`),
  KEY `consumable_consumpation_details_consumpation_id_foreign` (`consumpation_id`),
  KEY `consumable_consumpation_details_consumable_id_foreign` (`consumable_id`),
  CONSTRAINT `consumable_consumpation_details_consumable_id_foreign` FOREIGN KEY (`consumable_id`) REFERENCES `consumable_items` (`id`),
  CONSTRAINT `consumable_consumpation_details_consumpation_id_foreign` FOREIGN KEY (`consumpation_id`) REFERENCES `consumable_consumpations` (`id`) ON DELETE CASCADE,
  CONSTRAINT `consumable_consumpation_details_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `consumable_consumpation_details_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `consumable_consumpation_details` WRITE;
/*!40000 ALTER TABLE `consumable_consumpation_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumable_consumpation_details` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `consumable_consumpations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consumable_consumpations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `change_date` datetime NOT NULL,
  `narration` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `change_reason` enum('REGULAR_ROUTINE','MATERIAL_FAULT','MACHINE_FAULT','OTHER') COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `consumable_consumpations` WRITE;
/*!40000 ALTER TABLE `consumable_consumpations` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumable_consumpations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `consumable_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consumable_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `consumable_id` bigint(20) unsigned DEFAULT NULL,
  `item_id` bigint(20) unsigned NOT NULL,
  `qty` decimal(8,2) DEFAULT NULL,
  `qty_type` enum('PERCENTAGE','UNIT') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expected_pcs` decimal(25,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `consumable_details_consumable_id_foreign` (`consumable_id`),
  CONSTRAINT `consumable_details_consumable_id_foreign` FOREIGN KEY (`consumable_id`) REFERENCES `consumable_settings` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `consumable_details` WRITE;
/*!40000 ALTER TABLE `consumable_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumable_details` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `consumable_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consumable_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` json NOT NULL,
  `spec` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `add_spec` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `weight` decimal(25,2) DEFAULT NULL,
  `description` json DEFAULT NULL,
  `opening_stock` decimal(25,2) DEFAULT NULL,
  `unit_price` decimal(25,2) DEFAULT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  `opening_stock_unit` bigint(20) unsigned DEFAULT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `consumable_items_opening_stock_unit_foreign` (`opening_stock_unit`),
  KEY `consumable_items_created_by_foreign` (`created_by`),
  KEY `consumable_items_updated_by_foreign` (`updated_by`),
  KEY `consumable_items_category_id_foreign` (`category_id`),
  CONSTRAINT `consumable_items_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `consumable_categories` (`id`),
  CONSTRAINT `consumable_items_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `consumable_items_opening_stock_unit_foreign` FOREIGN KEY (`opening_stock_unit`) REFERENCES `units` (`id`),
  CONSTRAINT `consumable_items_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `consumable_items` WRITE;
/*!40000 ALTER TABLE `consumable_items` DISABLE KEYS */;
INSERT INTO `consumable_items` VALUES (1,'2020-02-14 17:52:54',NULL,'{\"en\": \"GangSaw-BigPunch\", \"hi\": \"\"}','23/20X10X30mm',NULL,NULL,NULL,216.00,24.00,1,1,1,NULL),(2,'2020-02-14 17:52:54',NULL,'{\"en\": \"GangSaw-MiddlePunch\", \"hi\": \"\"}','23/20X10X18mm',NULL,NULL,NULL,216.00,18.00,1,1,1,NULL),(3,'2020-02-14 17:52:54',NULL,'{\"en\": \"GangSaw-SmallPunch\", \"hi\": \"\"}','23/20X10X15mm',NULL,NULL,NULL,432.00,15.00,1,1,1,NULL),(4,'2020-02-14 17:52:54',NULL,'{\"en\": \"GangSaw-Spencer\", \"hi\": \"\"}','80X10X20mm',NULL,NULL,NULL,432.00,55.00,1,1,1,NULL),(5,'2020-02-14 17:52:54',NULL,'{\"en\": \"GangSaw-GraphitePlates\", \"hi\": \"\"}','80X12X82mm',NULL,NULL,NULL,18.00,120.00,1,1,1,NULL),(6,'2020-02-14 17:52:54',NULL,'{\"en\": \"Dressing-BigPunch\", \"hi\": \"\"}','26/23X10X37mm - V Shape',NULL,NULL,NULL,18.00,35.00,1,1,1,NULL),(7,'2020-02-14 17:52:54',NULL,'{\"en\": \"Dressing-MiddlePunch\", \"hi\": \"\"}','26/23X10X22mm - V Shape',NULL,NULL,NULL,18.00,20.00,1,1,1,NULL),(8,'2020-02-14 17:52:54',NULL,'{\"en\": \"Dressing-SmallPunch\", \"hi\": \"\"}','26/23X10X20mm - V Shape',NULL,NULL,NULL,18.00,20.00,1,1,1,NULL),(9,'2020-02-14 17:52:54',NULL,'{\"en\": \"Dressing-Spencer\", \"hi\": \"\"}','80X10X20mm - V Shape',NULL,NULL,NULL,432.00,56.00,1,1,1,NULL),(10,'2020-02-14 17:52:54',NULL,'{\"en\": \"Dressing Side Plates(L)\", \"hi\": \"\"}','90X40X12',NULL,NULL,NULL,432.00,56.00,1,1,1,NULL),(11,'2020-02-14 17:52:54',NULL,'{\"en\": \"Dressing Center Plates\", \"hi\": \"\"}','75X95X12',NULL,NULL,NULL,432.00,56.00,1,1,1,NULL),(12,'2020-02-14 17:52:54',NULL,'{\"en\": \"Dressing Side Plates\", \"hi\": \"\"}','75X95X12',NULL,NULL,NULL,432.00,56.00,1,1,1,NULL),(13,'2020-02-14 17:52:54',NULL,'{\"en\": \"Graphite-Block-50mm\", \"hi\": \"\"}','130X130X50mm',NULL,NULL,NULL,4.00,1550.00,1,1,1,NULL),(14,'2020-02-14 17:52:54',NULL,'{\"en\": \"IPA\", \"hi\": \"\"}','deepak',NULL,NULL,NULL,20.00,85.00,3,4,1,NULL),(15,'2020-02-14 17:52:54',NULL,'{\"en\": \"Acetone\", \"hi\": \"\"}','Herdalia',NULL,NULL,NULL,20.00,82.00,3,4,1,NULL),(16,'2020-02-14 17:52:54',NULL,'{\"en\": \"MDC\", \"hi\": \"\"}','Taiwan',NULL,NULL,NULL,150.00,79.00,3,4,1,NULL),(17,'2020-02-14 17:52:54',NULL,'{\"en\": \"Acrylic Resin Binder\", \"hi\": \"\"}','small powder dana',NULL,NULL,NULL,10.00,450.00,3,2,1,NULL),(18,'2020-02-14 17:52:54',NULL,'{\"en\": \"Plastic Dana Binder\", \"hi\": \"\"}','coarse powder dana',NULL,NULL,NULL,0.00,200.00,3,2,1,NULL),(19,'2020-02-14 17:52:54',NULL,'{\"en\": \"Gangsaw Die\", \"hi\": \"\"}','small powder dana',NULL,NULL,NULL,150.00,8000.00,7,1,1,NULL),(20,'2020-02-14 17:52:54',NULL,'{\"en\": \"ColdPress Rubber\", \"hi\": \"\"}','coldpress rubber',NULL,NULL,NULL,150.00,8000.00,8,1,1,NULL),(21,'2020-02-14 17:52:54',NULL,'{\"en\": \"MShape-SmallPunch\", \"hi\": \"\"}','24X10X15mm',NULL,NULL,NULL,0.00,20.00,1,1,1,NULL),(22,'2020-02-14 17:52:54',NULL,'{\"en\": \"MShape-BigPunch\", \"hi\": \"\"}','24X24X15mm',NULL,NULL,NULL,0.00,32.00,1,1,1,NULL),(23,'2020-02-14 17:52:54',NULL,'{\"en\": \"MShape-Spencer\", \"hi\": \"\"}','80X24X10mm',NULL,NULL,NULL,0.00,61.00,1,1,1,NULL),(24,'2020-02-14 17:52:54',NULL,'{\"en\": \"Plain-Spencer\", \"hi\": \"\"}','80X24X10mm',NULL,NULL,NULL,0.00,55.00,1,1,1,NULL),(25,'2020-02-14 17:52:54',NULL,'{\"en\": \"BoxType-23mm-BigPunch\", \"hi\": \"\"}','23X15X36mm',NULL,NULL,NULL,0.00,34.00,1,1,1,NULL),(26,'2020-02-14 17:52:54',NULL,'{\"en\": \"BoxType-23mm-MiddlePunch\", \"hi\": \"\"}','23X15X22mm',NULL,NULL,NULL,0.00,20.00,1,1,1,NULL),(27,'2020-02-14 17:52:54',NULL,'{\"en\": \"BoxType-23mm-SmallPunch\", \"hi\": \"\"}','23X15X18mm',NULL,NULL,NULL,0.00,16.00,1,1,1,NULL),(28,'2020-02-14 17:52:54',NULL,'{\"en\": \"BoxType-23mm-SmallPunch\", \"hi\": \"\"}','23X15X18mm',NULL,NULL,NULL,0.00,16.00,1,1,1,NULL),(29,'2020-02-14 17:52:54',NULL,'{\"en\": \"Natural Sand\", \"hi\": \"\"}','23X15X18mm',NULL,NULL,NULL,0.00,1.00,1,3,1,NULL),(30,'2020-02-26 03:42:40','2020-02-26 03:42:40','{\"en\": \"Metal Powder\", \"hi\": \"Metal Powder\"}',NULL,NULL,0.00,'{\"en\": null, \"hi\": null}',0.00,0.00,9,2,1,NULL),(31,'2020-02-26 03:43:05','2020-02-26 03:43:05','{\"en\": \"Diamond Powder\", \"hi\": \"Diamond Powder\"}',NULL,NULL,0.00,'{\"en\": null, \"hi\": null}',0.00,0.00,9,2,1,NULL),(32,'2020-02-28 06:30:46','2020-02-28 06:30:46','{\"en\": \"Gangsaw Big Patti\", \"hi\": \"Gangsaw Big Patti\"}','22.3X19.3X0.5 MM',NULL,NULL,'{\"en\": \"Gangsaw Big Patti\", \"hi\": \"Gangsaw Big Patti\"}',0.00,0.00,2,NULL,1,NULL),(33,'2020-02-28 06:31:34','2020-02-28 06:31:34','{\"en\": \"Box Big Patti\", \"hi\": \"Box Big Patti\"}','22.75X14.75X1MM',NULL,0.00,'{\"en\": \"Box Big Patti\", \"hi\": \"Box Big Patti\"}',0.00,0.00,2,NULL,1,NULL),(34,'2020-02-28 06:34:06','2020-02-28 06:34:06','{\"en\": \"Gangsaw Graphite Plate (81X81X10)\", \"hi\": \"Gangsaw Graphite Plate (81X81X10)\"}','81X81X10 mm',NULL,0.00,'{\"en\": \"Gangsaw Graphite Plate (81X81X10)\", \"hi\": \"Gangsaw Graphite Plate (81X81X10)\"}',0.00,0.00,10,1,1,NULL),(35,'2020-02-28 06:35:05','2020-02-28 06:35:05','{\"en\": \"Box Big Punch (23X15X36)\", \"hi\": \"Box Big Punch (23X15X36)\"}','23X15X36 MM',NULL,0.00,'{\"en\": \"Box Big Punch (23X15X36)\", \"hi\": \"Box Big Punch (23X15X36)\"}',0.00,0.00,10,1,1,NULL),(36,'2020-02-28 07:04:05','2020-02-28 07:04:05','{\"en\": \"Box Middle Punch (23X15X22)\", \"hi\": \"Box Middle Punch (23X15X22)\"}','23X15X22 MM No Taper',NULL,0.00,'{\"en\": \"Box Middle Punch (23X15X22)\", \"hi\": \"Box Middle Punch (23X15X22)\"}',0.00,0.00,10,1,1,NULL),(37,'2020-02-28 07:04:46','2020-02-28 07:04:46','{\"en\": \"Box Small Punch (23X15X18)\", \"hi\": \"Box Small Punch (23X15X18)\"}','23X15X18 MM No Taper',NULL,0.00,'{\"en\": \"Box Small Punch (23X15X18)\", \"hi\": \"Box Small Punch (23X15X18)\"}',0.00,0.00,10,1,1,NULL),(38,'2020-02-28 07:06:01','2020-02-28 07:11:01','{\"en\": \"Box Side L Plate (80X100X10)\", \"hi\": \"Box Side L Plate (80X100X10)\"}','80X100X10 MM',NULL,0.00,'{\"en\": \"Box Side L Plate (80X100X10)\", \"hi\": \"Box Side L Plate (80X100X10)\"}',0.00,0.00,10,1,1,1),(39,'2020-02-28 07:06:44','2020-02-28 07:06:44','{\"en\": \"Box Side R Plate (80X85X10)\", \"hi\": \"Box Side R Plate (80X85X10)\"}','80X85X10 MM',NULL,0.00,'{\"en\": \"Box Side R Plate (80X85X10)\", \"hi\": \"Box Side R Plate (80X85X10)\"}',0.00,0.00,10,1,1,NULL),(40,'2020-02-28 07:07:53','2020-02-28 07:07:53','{\"en\": \"Grangsaw Big Punch (23/20X10X30)\", \"hi\": \"Grangsaw Big Punch (23/20X10X30)\"}','23/20X10X30 MM .25MM Taper Each Side',NULL,0.00,'{\"en\": \"Grangsaw Big Punch (23/20X10X30)\", \"hi\": \"Grangsaw Big Punch (23/20X10X30)\"}',0.00,0.00,10,1,1,NULL),(41,'2020-02-28 07:08:32','2020-02-28 07:08:32','{\"en\": \"Gangsaw Middle Punch (23/20X10X18)\", \"hi\": \"Gangsaw Middle Punch (23/20X10X18)\"}','23/20X10X18 MM .25MM Taper Each Side',NULL,0.00,'{\"en\": \"Gangsaw Middle Punch (23/20X10X18)\", \"hi\": \"Gangsaw Middle Punch (23/20X10X18)\"}',0.00,0.00,10,1,1,NULL),(42,'2020-02-28 07:09:39','2020-02-28 07:09:39','{\"en\": \"Gangsaw Small Punch (23/20X10X15)\", \"hi\": \"Gangsaw Small Punch (23/20X10X15)\"}','23/20X10X15 MM .25MM Taper Each Side',NULL,0.00,'{\"en\": \"Gangsaw Small Punch (23/20X10X15)\", \"hi\": \"Gangsaw Small Punch (23/20X10X15)\"}',0.00,0.00,10,1,1,NULL),(43,'2020-02-28 07:10:24','2020-02-28 07:10:24','{\"en\": \"Gangsaw Spencer (80X10X20)\", \"hi\": \"Gangsaw Spencer (80X10X20)\"}','80X10X20 MM',NULL,0.00,'{\"en\": \"Gangsaw Spencer (80X10X20)\", \"hi\": \"Gangsaw Spencer (80X10X20)\"}',0.00,0.00,10,1,1,NULL),(44,'2020-03-07 01:28:02','2020-03-07 01:28:02','{\"en\": \"8 Inch Grinding Wheel\", \"hi\": \"8 Inch Grinding Wheel\"}','8 Inch',NULL,0.00,'{\"en\": \"8 Inch Grinding Wheel\", \"hi\": \"8 Inch Grinding Wheel\"}',0.00,0.00,4,NULL,1,NULL);
/*!40000 ALTER TABLE `consumable_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `consumable_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consumable_settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` enum('COLDPRESS_DIE','PATTI','THERMOCOUPLE','MOULD','PACKING','BEAD_RUBBER_COATING','BEAD_PLASTIC_COATING','GRINDING','FINISHING','HOT_PRESS_ACCESSORIES','COLD_PRESS_ACCESSORIES','BINDER','OTHER') COLLATE utf8mb4_unicode_ci NOT NULL,
  `qty` decimal(25,2) DEFAULT NULL,
  `qty_type` enum('PERCENTAGE','UNIT') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned DEFAULT NULL,
  `deleted_by` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `consumable_settings_created_by_foreign` (`created_by`),
  KEY `consumable_settings_updated_by_foreign` (`updated_by`),
  KEY `consumable_settings_deleted_by_foreign` (`deleted_by`),
  CONSTRAINT `consumable_settings_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `consumable_settings_deleted_by_foreign` FOREIGN KEY (`deleted_by`) REFERENCES `users` (`id`),
  CONSTRAINT `consumable_settings_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `consumable_settings` WRITE;
/*!40000 ALTER TABLE `consumable_settings` DISABLE KEYS */;
INSERT INTO `consumable_settings` VALUES (1,'2020-02-14 17:52:54',NULL,'GangsawMouldSettings','GangsawMouldSettings','Gangsaw Mould Cost','MOULD',72.00,'UNIT',1,NULL,NULL),(2,'2020-02-14 17:52:54',NULL,'BoxMouldSettings','BoxMouldSettings','Box Mould Cost','MOULD',36.00,'UNIT',1,NULL,NULL),(3,'2020-02-14 17:52:54',NULL,'MShapeMouldSettings','MShapeMouldSettings','MShape Mould Cost','MOULD',36.00,'UNIT',1,NULL,NULL),(4,'2020-02-14 17:52:54',NULL,'DressingMouldSettings','DressingMouldSettings','Dressing Mould Cost','MOULD',48.00,'UNIT',1,NULL,NULL),(5,'2020-02-14 17:52:54',NULL,'IpaAcetoneGenericBinderSettings','IpaAcetoneGenericBinderSettings','Binder Cost','BINDER',8.00,'PERCENTAGE',1,NULL,NULL),(6,'2020-02-14 17:52:54',NULL,'IpaAcetoneBoxGenericBinderSettings','IpaAcetoneGenericBinderSettings','Binder Cost','BINDER',10.00,'PERCENTAGE',1,NULL,NULL),(7,'2020-02-14 17:52:54',NULL,'GangsawDieSettings','GangsawDieSettings','Gangsaw Die Cost','COLDPRESS_DIE',NULL,NULL,1,NULL,NULL),(8,'2020-02-14 17:52:54',NULL,'BoxDieSettings','BoxDieSettings','Box Die Cost','COLDPRESS_DIE',NULL,NULL,1,NULL,NULL),(9,'2020-02-14 17:52:54',NULL,'DressingDieSettings','DressingDieSettings','Dressing Die Cost','COLDPRESS_DIE',NULL,NULL,1,NULL,NULL),(10,'2020-02-14 17:52:54',NULL,'MShapeDieSettings','MShapeDieSettings','MShape Die Cost','COLDPRESS_DIE',NULL,NULL,1,NULL,NULL),(11,'2020-02-14 17:52:54',NULL,'GangsawGrindingWheelSettings','GangsawGrindingWheelSettings','GrindingWheel Cost','GRINDING',NULL,NULL,1,NULL,NULL),(12,'2020-02-14 17:52:54',NULL,'BoxGrindingWheelSettings','BoxGrindingWheelSettings','GrindingWheel Cost','GRINDING',NULL,NULL,1,NULL,NULL),(13,'2020-02-14 17:52:54',NULL,'MShapeGrindingWheelSettings','MShapeGrindingWheelSettings','GrindingWheel Cost','GRINDING',NULL,NULL,1,NULL,NULL),(14,'2020-02-14 17:52:54',NULL,'DressingGrindingWheelSettings','DressingGrindingWheelSettings','GrindingWheel Cost','GRINDING',NULL,NULL,1,NULL,NULL),(15,'2020-02-14 17:52:54',NULL,'GangsawPolythenePackingSettings','GangsawPolythenePackingSettings','Gangsaw Polythene Packing Cost','PACKING',800.00,'UNIT',1,NULL,NULL),(16,'2020-02-14 17:52:54',NULL,'GangsawPouchPackingSettings','GangsawPouchPackingSettings','Gangsaw Pouch Packing Cost','PACKING',800.00,'UNIT',1,NULL,NULL),(17,'2020-02-14 17:52:54',NULL,'BoxPouchPackingSettings','BoxPouchPackingSettings','Box Pouch Packing Cost','PACKING',90.00,'UNIT',1,NULL,NULL),(18,'2020-02-14 17:52:54',NULL,'DressingPouchPackingSettings','DressingPouchPackingSettings','Dressing Pouch Packing Cost','PACKING',33.00,'UNIT',1,NULL,NULL),(19,'2020-02-14 17:52:54',NULL,'GangsawThermocoupleSettings','GangsawThermocoupleSettings','Gangsaw Thermocouple Cost','THERMOCOUPLE',NULL,NULL,1,NULL,NULL),(20,'2020-02-14 17:52:54',NULL,'DressingThermocoupleSettings','DressingThermocoupleSettings','Dressing Thermocouple Cost','THERMOCOUPLE',NULL,NULL,1,NULL,NULL),(21,'2020-02-14 17:52:54',NULL,'BoxThermocoupleSettings','BoxThermocoupleSettings','Box Thermocouple Cost','THERMOCOUPLE',NULL,NULL,1,NULL,NULL),(22,'2020-02-14 17:52:54',NULL,'NaturalSandFinisingSettings','NaturalSandFinisingSettings','Sand Finising','FINISHING',NULL,NULL,1,NULL,NULL),(23,'2020-02-14 17:52:54',NULL,'SandBlasingFinisingSettings','SandBlasingFinisingSettings','Sand Blasting Finising','FINISHING',NULL,NULL,1,NULL,NULL),(24,'2020-02-14 17:52:54',NULL,'EletroplatingFinisingSettings','EletroplatingFinisingSettings','Electroplating Finising','FINISHING',NULL,NULL,1,NULL,NULL),(25,'2020-02-14 17:52:54',NULL,'GangsawPattiSettings-23mm','GangsawPattiSettings-23mm','Gangsaw-Patti-23mm','PATTI',NULL,NULL,1,NULL,NULL),(26,'2020-02-14 17:52:54',NULL,'BoxPattiSettings-23mm','BoxPattiSettings-23mm','Box-Patti-23mm','PATTI',NULL,NULL,1,NULL,NULL);
/*!40000 ALTER TABLE `consumable_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `consumable_stock_view`;
/*!50001 DROP VIEW IF EXISTS `consumable_stock_view`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE VIEW `consumable_stock_view` AS SELECT 
 1 AS `id`,
 1 AS `consumable_name`,
 1 AS `spec`,
 1 AS `add_spec`,
 1 AS `weight`,
 1 AS `qty`,
 1 AS `unit_price`,
 1 AS `stock_value`,
 1 AS `category`,
 1 AS `alias`,
 1 AS `category_id`,
 1 AS `created_at`,
 1 AS `consumed_percentage`,
 1 AS `consumed_qty`,
 1 AS `type`*/;
SET character_set_client = @saved_cs_client;
DROP TABLE IF EXISTS `consumpation_price_view`;
/*!50001 DROP VIEW IF EXISTS `consumpation_price_view`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE VIEW `consumpation_price_view` AS SELECT 
 1 AS `id`,
 1 AS `consumpation_id`,
 1 AS `consumable_id`,
 1 AS `qty`,
 1 AS `consumed_percentage`,
 1 AS `created_at`,
 1 AS `updated_at`,
 1 AS `created_by`,
 1 AS `updated_by`,
 1 AS `unit_price`*/;
SET character_set_client = @saved_cs_client;
DROP TABLE IF EXISTS `employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `employees` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phoneNo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `aadhar_no` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pan_no` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employees` WRITE;
/*!40000 ALTER TABLE `employees` DISABLE KEYS */;
INSERT INTO `employees` VALUES (1,'Prakash Gujjar',NULL,NULL,NULL,NULL,NULL,'2020-03-07 04:40:10',NULL),(2,'Manish Paliwal',NULL,NULL,NULL,NULL,NULL,'2020-03-07 04:40:10',NULL),(3,'Ratan',NULL,NULL,NULL,NULL,NULL,'2020-03-07 04:40:10',NULL),(4,'Mukesh',NULL,NULL,NULL,NULL,NULL,'2020-03-07 04:40:10',NULL);
/*!40000 ALTER TABLE `employees` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `entries` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `entrytype_id` bigint(20) unsigned NOT NULL,
  `ref_number` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tr_date` date NOT NULL,
  `invoice_ref_id` bigint(20) unsigned DEFAULT NULL,
  `cr_total` decimal(25,2) NOT NULL DEFAULT '0.00',
  `dr_total` decimal(25,2) NOT NULL DEFAULT '0.00',
  `narration` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_by` bigint(20) unsigned DEFAULT NULL,
  `updated_by` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `entries_entrytype_id_foreign` (`entrytype_id`),
  KEY `entries_invoice_ref_id_foreign` (`invoice_ref_id`),
  CONSTRAINT `entries_entrytype_id_foreign` FOREIGN KEY (`entrytype_id`) REFERENCES `entry_types` (`id`),
  CONSTRAINT `entries_invoice_ref_id_foreign` FOREIGN KEY (`invoice_ref_id`) REFERENCES `invoices` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `entries` WRITE;
/*!40000 ALTER TABLE `entries` DISABLE KEYS */;
INSERT INTO `entries` VALUES (23,5,'2020/02/12-1','2020-02-12',20,93988.00,0.00,NULL,'2020-02-24 06:48:06','2020-02-26 04:06:08',3,1),(24,2,'2020/02/24-21','2020-02-24',NULL,93988.00,93988.00,'',NULL,NULL,NULL,NULL),(29,1,'2020/02/25-21','2020-02-25',NULL,5000.00,5000.00,'',NULL,NULL,NULL,NULL),(30,2,'2020/02/27-21','2020-02-27',NULL,23600.00,23600.00,'',NULL,NULL,NULL,NULL),(31,5,'2020/02/26-21','2020-02-26',21,36448.00,0.00,NULL,'2020-03-01 12:24:14',NULL,1,NULL),(32,1,'2020/02/29-22','2020-02-29',NULL,150000.00,150000.00,'by cheque',NULL,NULL,NULL,NULL),(33,6,'25','2020-02-29',22,0.00,12500.00,NULL,'2020-03-03 12:07:43','2020-03-03 12:17:21',3,3),(34,6,'26','2020-03-01',23,0.00,44000.00,NULL,'2020-03-04 06:58:18',NULL,3,NULL),(35,6,'27','2020-03-02',24,0.00,34000.00,NULL,'2020-03-04 07:11:25',NULL,3,NULL),(36,6,'29','2020-03-04',25,0.00,44000.00,NULL,'2020-03-04 07:13:37',NULL,3,NULL),(37,6,'2020/03/04-26','2020-03-04',28,0.00,54560.00,NULL,'2020-03-04 10:44:23',NULL,3,NULL),(39,5,'2020/03/03-30','2020-03-03',30,13986.00,0.00,NULL,'2020-03-05 07:17:47',NULL,3,NULL),(40,5,'2020/03/03-31','2020-03-03',31,14156.00,0.00,NULL,'2020-03-05 07:19:38',NULL,3,NULL),(41,5,'2020/03/04-32','2020-03-04',32,10403.52,0.00,NULL,'2020-03-05 07:26:15',NULL,3,NULL),(42,1,'2020/03/06-33','2020-03-06',NULL,41500.00,41500.00,'',NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `entries` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `entry_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `entry_tags` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `background_color` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `entry_tags` WRITE;
/*!40000 ALTER TABLE `entry_tags` DISABLE KEYS */;
INSERT INTO `entry_tags` VALUES (1,'normal entry','#000','#f0f0f0','2020-02-14 17:52:54',NULL);
/*!40000 ALTER TABLE `entry_tags` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `entry_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `entry_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tag_id` bigint(20) unsigned NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `base_type` int(11) NOT NULL DEFAULT '0',
  `numbering` int(11) NOT NULL DEFAULT '1',
  `prefix` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `suffix` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zero_padding` int(11) NOT NULL DEFAULT '0',
  `restriction_bankcash` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `entry_types_tag_id_foreign` (`tag_id`),
  CONSTRAINT `entry_types_tag_id_foreign` FOREIGN KEY (`tag_id`) REFERENCES `entry_tags` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `entry_types` WRITE;
/*!40000 ALTER TABLE `entry_types` DISABLE KEYS */;
INSERT INTO `entry_types` VALUES (1,'Receipt','receipt',1,'Received in Bank account or Cash account',1,1,'','',0,2,'2020-02-14 17:52:54',NULL,NULL),(2,'Payment','payment',1,'Payment made from Bank account or Cash account',1,1,'','',0,3,'2020-02-14 17:52:54',NULL,NULL),(3,'Contra','contra',1,'Payment made from Bank account or Cash account',1,1,'','',0,4,'2020-02-14 17:52:54',NULL,NULL),(4,'Journal','journal',1,'Transfer between Non Bank account and Cash account',1,1,'','',0,5,'2020-02-14 17:52:54',NULL,NULL),(5,'Purchase','purchase',1,'Purchase',1,1,'','',0,5,'2020-02-14 17:52:54',NULL,NULL),(6,'Sale','sales',1,'Sale',1,1,'','',0,5,'2020-02-14 17:52:54',NULL,NULL);
/*!40000 ALTER TABLE `entry_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `entryitems`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `entryitems` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `entry_id` bigint(20) unsigned NOT NULL,
  `account_id` bigint(20) unsigned NOT NULL,
  `cr_total` decimal(25,2) NOT NULL,
  `dr_total` decimal(25,2) NOT NULL,
  `reconciliation_date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `entryitems_entry_id_foreign` (`entry_id`),
  CONSTRAINT `entryitems_entry_id_foreign` FOREIGN KEY (`entry_id`) REFERENCES `entries` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `entryitems` WRITE;
/*!40000 ALTER TABLE `entryitems` DISABLE KEYS */;
INSERT INTO `entryitems` VALUES (44,24,61,93988.00,0.00,'0000-00-00',NULL,NULL),(45,24,30,0.00,93988.00,'0000-00-00',NULL,NULL),(47,23,30,93988.00,0.00,'0000-00-00','2020-02-26 04:06:08',NULL),(55,29,46,5000.00,0.00,'0000-00-00',NULL,NULL),(56,29,60,0.00,5000.00,'0000-00-00',NULL,NULL),(57,30,61,23600.00,0.00,'0000-00-00',NULL,NULL),(58,30,62,0.00,23600.00,'0000-00-00',NULL,NULL),(59,31,26,36448.00,0.00,'0000-00-00','2020-03-01 12:24:14',NULL),(62,32,20,150000.00,0.00,'0000-00-00','2020-03-01 12:38:12',NULL),(63,32,61,0.00,150000.00,'0000-00-00','2020-03-01 12:38:12',NULL),(66,33,64,0.00,12500.00,'0000-00-00','2020-03-03 12:17:21',NULL),(67,34,65,0.00,44000.00,'0000-00-00','2020-03-04 06:58:18',NULL),(68,35,63,0.00,34000.00,'0000-00-00','2020-03-04 07:11:25',NULL),(69,36,65,0.00,44000.00,'0000-00-00','2020-03-04 07:13:37',NULL),(70,37,65,0.00,54560.00,'0000-00-00','2020-03-04 10:44:23',NULL),(76,39,27,13986.00,0.00,'0000-00-00','2020-03-05 07:17:47',NULL),(77,40,28,14156.00,0.00,'0000-00-00','2020-03-05 07:19:38',NULL),(78,41,26,10403.52,0.00,'0000-00-00','2020-03-05 07:26:15',NULL),(79,42,53,41500.00,0.00,'0000-00-00',NULL,NULL),(80,42,60,0.00,41500.00,'0000-00-00',NULL,NULL);
/*!40000 ALTER TABLE `entryitems` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_consumable_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_consumable_detail` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint(20) unsigned NOT NULL,
  `consumable_id` bigint(20) unsigned NOT NULL,
  `qty` decimal(25,2) NOT NULL,
  `unit_price` decimal(25,2) NOT NULL,
  `amount` decimal(25,2) NOT NULL,
  `cgst` decimal(25,2) DEFAULT '0.00',
  `sgst` decimal(25,2) DEFAULT '0.00',
  `igst` decimal(25,2) DEFAULT '0.00',
  `cgst_value` decimal(25,2) DEFAULT '0.00',
  `sgst_value` decimal(25,2) DEFAULT '0.00',
  `igst_value` decimal(25,2) DEFAULT '0.00',
  `net_gst` decimal(25,2) DEFAULT '0.00',
  `discount` decimal(25,2) DEFAULT '0.00',
  `discount_val` decimal(25,2) DEFAULT '0.00',
  `net_amount` decimal(25,2) DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_consumable_detail_invoice_id_foreign` (`invoice_id`),
  KEY `invoice_consumable_detail_created_by_foreign` (`created_by`),
  KEY `invoice_consumable_detail_updated_by_foreign` (`updated_by`),
  KEY `invoice_consumable_detail_consumable_id_foreign` (`consumable_id`),
  CONSTRAINT `invoice_consumable_detail_consumable_id_foreign` FOREIGN KEY (`consumable_id`) REFERENCES `consumable_items` (`id`),
  CONSTRAINT `invoice_consumable_detail_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `invoice_consumable_detail_invoice_id_foreign` FOREIGN KEY (`invoice_id`) REFERENCES `invoices` (`id`) ON DELETE CASCADE,
  CONSTRAINT `invoice_consumable_detail_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_consumable_detail` WRITE;
/*!40000 ALTER TABLE `invoice_consumable_detail` DISABLE KEYS */;
INSERT INTO `invoice_consumable_detail` VALUES (27,20,1,4.00,22750.00,91000.00,0.00,0.00,3.00,0.00,0.00,2730.00,2730.00,0.00,0.00,93730.00,'2020-02-26 04:06:08',NULL,1,NULL),(28,21,40,300.00,25.00,7500.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,7500.00,'2020-03-01 12:24:14',NULL,1,NULL),(29,30,30,6.00,1950.00,11700.00,9.00,9.00,0.00,1053.00,1053.00,0.00,2106.00,0.00,0.00,13806.00,'2020-03-05 07:17:47',NULL,3,NULL),(30,31,30,6.00,1950.00,11700.00,9.00,9.00,0.00,1053.00,1053.00,0.00,2106.00,0.00,0.00,13806.00,'2020-03-05 07:19:38',NULL,3,NULL),(31,32,42,170.00,14.00,2380.00,9.00,9.00,0.00,214.20,214.20,0.00,428.40,0.00,0.00,2808.40,'2020-03-05 07:26:15',NULL,3,NULL),(32,32,41,149.00,16.00,2384.00,9.00,9.00,0.00,214.56,214.56,0.00,429.12,0.00,0.00,2813.12,'2020-03-05 07:26:15',NULL,3,NULL),(33,32,40,156.00,25.00,3900.00,9.00,9.00,0.00,351.00,351.00,0.00,702.00,0.00,0.00,4602.00,'2020-03-05 07:26:15',NULL,3,NULL);
/*!40000 ALTER TABLE `invoice_consumable_detail` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoices` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `invoice_date` date NOT NULL,
  `invoice_final_date` date DEFAULT NULL,
  `account_id` bigint(20) unsigned NOT NULL,
  `invoice_number` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `narration` text COLLATE utf8mb4_unicode_ci,
  `invoice_type` enum('CONSUMABLE','POWDER','PENDING','PRODUCT') COLLATE utf8mb4_unicode_ci NOT NULL,
  `ref_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `taxable_amount` decimal(25,2) DEFAULT '0.00',
  `cgst` decimal(25,2) DEFAULT '0.00',
  `sgst` decimal(25,2) DEFAULT '0.00',
  `igst` decimal(25,2) DEFAULT '0.00',
  `net_gst` decimal(25,2) DEFAULT '0.00',
  `packing_charge` decimal(25,2) DEFAULT '0.00',
  `total_discount` decimal(25,2) DEFAULT '0.00',
  `transport` decimal(25,2) DEFAULT '0.00',
  `billedAmount` decimal(25,2) DEFAULT '0.00',
  `totalAmount` decimal(25,2) DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `invoices_invoice_number_unique` (`invoice_number`),
  KEY `invoices_created_by_foreign` (`created_by`),
  KEY `invoices_updated_by_foreign` (`updated_by`),
  KEY `invoices_account_id_foreign` (`account_id`),
  CONSTRAINT `invoices_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`),
  CONSTRAINT `invoices_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `invoices_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoices` WRITE;
/*!40000 ALTER TABLE `invoices` DISABLE KEYS */;
INSERT INTO `invoices` VALUES (20,'2020-02-12',NULL,30,'2020/02/12-1',NULL,'CONSUMABLE',NULL,91000.00,0.00,0.00,2730.00,2730.00,NULL,0.00,258.00,0.00,93988.00,'2020-02-24 06:48:06','2020-02-26 04:06:08',3,1),(21,'2020-02-26',NULL,26,'2020/02/26-21',NULL,'CONSUMABLE','49',36448.00,0.00,0.00,0.00,0.00,NULL,0.00,NULL,0.00,36448.00,'2020-03-01 12:24:14',NULL,1,NULL),(22,'2020-02-29',NULL,64,'25',NULL,'PRODUCT',NULL,12500.00,0.00,0.00,0.00,0.00,NULL,0.00,NULL,0.00,12500.00,'2020-03-03 12:07:43','2020-03-03 12:17:21',3,3),(23,'2020-03-01',NULL,65,'26',NULL,'PRODUCT',NULL,44000.00,0.00,0.00,0.00,0.00,NULL,0.00,NULL,0.00,44000.00,'2020-03-04 06:58:18',NULL,3,NULL),(24,'2020-03-02',NULL,63,'27',NULL,'PRODUCT',NULL,34000.00,0.00,0.00,0.00,0.00,NULL,0.00,NULL,0.00,34000.00,'2020-03-04 07:11:25',NULL,3,NULL),(25,'2020-03-04',NULL,65,'29',NULL,'PRODUCT',NULL,44000.00,0.00,0.00,0.00,0.00,NULL,0.00,NULL,0.00,44000.00,'2020-03-04 07:13:37',NULL,3,NULL),(28,'2020-03-04',NULL,65,'2020/03/04-26','1000 pic bina I\'d ke he is let 1000*40 kre','PRODUCT','29',54560.00,0.00,0.00,0.00,0.00,NULL,0.00,NULL,0.00,54560.00,'2020-03-04 10:44:23',NULL,3,NULL),(30,'2020-03-03',NULL,27,'2020/03/03-30',NULL,'CONSUMABLE',NULL,11700.00,1053.00,1053.00,0.00,2106.00,NULL,0.00,180.00,0.00,13986.00,'2020-03-05 07:17:47',NULL,3,NULL),(31,'2020-03-03',NULL,28,'2020/03/03-31',NULL,'CONSUMABLE',NULL,11700.00,1053.00,1053.00,0.00,2106.00,NULL,0.00,350.00,0.00,14156.00,'2020-03-05 07:19:38',NULL,3,NULL),(32,'2020-03-04',NULL,26,'2020/03/04-32',NULL,'CONSUMABLE',NULL,8664.00,779.76,779.76,0.00,1559.52,NULL,0.00,180.00,0.00,10403.52,'2020-03-05 07:26:15',NULL,3,NULL);
/*!40000 ALTER TABLE `invoices` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `laravel2step`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `laravel2step` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userId` bigint(20) unsigned NOT NULL,
  `authCode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `authCount` int(11) NOT NULL,
  `authStatus` tinyint(1) NOT NULL DEFAULT '0',
  `authDate` datetime DEFAULT NULL,
  `requestDate` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `laravel2step_userid_index` (`userId`),
  CONSTRAINT `laravel2step_userid_foreign` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `laravel2step` WRITE;
/*!40000 ALTER TABLE `laravel2step` DISABLE KEYS */;
/*!40000 ALTER TABLE `laravel2step` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `laravel_logger_activity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `laravel_logger_activity` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `userType` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `userId` int(11) DEFAULT NULL,
  `route` longtext COLLATE utf8mb4_unicode_ci,
  `ipAddress` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `userAgent` text COLLATE utf8mb4_unicode_ci,
  `locale` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referer` longtext COLLATE utf8mb4_unicode_ci,
  `methodType` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=142 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `laravel_logger_activity` WRITE;
/*!40000 ALTER TABLE `laravel_logger_activity` DISABLE KEYS */;
INSERT INTO `laravel_logger_activity` VALUES (1,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','47.31.89.68','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/login','POST','2020-02-14 17:52:09','2020-02-14 17:52:09',NULL),(2,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','47.31.89.68','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/login','POST','2020-02-14 17:52:21','2020-02-14 17:52:21',NULL),(3,'Locked Out','Guest',NULL,'https://amarsuperhardtools.com/login','47.31.89.68','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/login','POST','2020-02-14 17:53:01','2020-02-14 17:53:01',NULL),(4,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','47.31.89.68','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/login','POST','2020-02-14 18:40:49','2020-02-14 18:40:49',NULL),(5,'Logged Out','Registered',1,'https://amarsuperhardtools.com/admin/password/post_expired','47.31.89.68','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/admin/password/expired','POST','2020-02-14 19:08:05','2020-02-14 19:08:05',NULL),(6,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','47.31.89.68','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/login','POST','2020-02-14 19:09:15','2020-02-14 19:09:15',NULL),(7,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','112.110.122.22','Mozilla/5.0 (Linux; Android 10; motorola one power Build/QPTS30.61-18-2; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.99 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-14 19:10:56','2020-02-14 19:10:56',NULL),(8,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','47.30.194.125','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/login','POST','2020-02-15 18:11:57','2020-02-15 18:11:57',NULL),(9,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','157.37.115.254','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-22 05:02:06','2020-02-22 05:02:06',NULL),(10,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','157.37.115.254','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-22 05:02:23','2020-02-22 05:02:23',NULL),(11,'Logged In','Registered',3,'https://amarsuperhardtools.com/login','157.37.115.254','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-22 05:05:05','2020-02-22 05:05:05',NULL),(12,'Logged Out','Registered',3,'https://amarsuperhardtools.com/admin/password/post_expired','157.37.115.254','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/admin/password/expired','POST','2020-02-22 05:06:45','2020-02-22 05:06:45',NULL),(13,'Logged In','Registered',3,'https://amarsuperhardtools.com/login','157.37.1.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-22 05:07:31','2020-02-22 05:07:31',NULL),(14,'Logged In','Registered',3,'https://amarsuperhardtools.com/login','223.189.184.146','Mozilla/5.0 (Linux; Android 9; vivo 1901 Build/PPR1.180610.011; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/74.0.3729.136 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-22 05:48:55','2020-02-22 05:48:55',NULL),(15,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','157.37.1.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/login','POST','2020-02-22 05:51:30','2020-02-22 05:51:30',NULL),(16,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','157.37.1.92','Mozilla/5.0 (Linux; Android 10; motorola one power Build/QPTS30.61-18-2; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.117 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-22 09:50:54','2020-02-22 09:50:54',NULL),(17,'Logged In','Registered',3,'https://amarsuperhardtools.com/login','223.189.176.176','Mozilla/5.0 (Linux; Android 9; vivo 1901 Build/PPR1.180610.011; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/74.0.3729.136 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-23 00:22:21','2020-02-23 00:22:21',NULL),(18,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','157.47.153.213','Mozilla/5.0 (Linux; Android 10; motorola one power Build/QPTS30.61-18-2; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.117 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-23 01:34:47','2020-02-23 01:34:47',NULL),(19,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','223.189.176.176','Mozilla/5.0 (Linux; Android 9; vivo 1901 Build/PPR1.180610.011; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/74.0.3729.136 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-23 01:58:30','2020-02-23 01:58:30',NULL),(20,'Logged In','Registered',3,'https://amarsuperhardtools.com/login','223.189.176.176','Mozilla/5.0 (Linux; Android 9; vivo 1901 Build/PPR1.180610.011; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/74.0.3729.136 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-23 01:59:50','2020-02-23 01:59:50',NULL),(21,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','157.47.153.213','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/login','POST','2020-02-23 02:06:05','2020-02-23 02:06:05',NULL),(22,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','157.47.153.213','Mozilla/5.0 (Linux; Android 10; motorola one power Build/QPTS30.61-18-2; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.117 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-23 05:13:18','2020-02-23 05:13:18',NULL),(23,'Logged In','Registered',2,'https://amarsuperhardtools.com/login','157.47.153.213','Mozilla/5.0 (Linux; Android 10; motorola one power Build/QPTS30.61-18-2; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.117 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-23 05:20:21','2020-02-23 05:20:21',NULL),(24,'Logged Out','Registered',2,'https://amarsuperhardtools.com/admin/password/post_expired','157.47.153.213','Mozilla/5.0 (Linux; Android 10; motorola one power Build/QPTS30.61-18-2; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.117 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/admin/password/expired','POST','2020-02-23 05:20:59','2020-02-23 05:20:59',NULL),(25,'Logged Out','Registered',1,'https://amarsuperhardtools.com/logout','157.47.153.213','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/admin/roles','POST','2020-02-23 05:21:47','2020-02-23 05:21:47',NULL),(26,'Logged In','Registered',2,'https://amarsuperhardtools.com/login','157.47.153.213','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/login','POST','2020-02-23 05:22:09','2020-02-23 05:22:09',NULL),(27,'Logged Out','Registered',2,'https://amarsuperhardtools.com/logout','157.47.153.213','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/admin/home','POST','2020-02-23 05:23:07','2020-02-23 05:23:07',NULL),(28,'Logged In','Registered',2,'https://amarsuperhardtools.com/login','157.47.153.213','Mozilla/5.0 (Linux; Android 10; motorola one power Build/QPTS30.61-18-2; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.117 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-23 05:23:17','2020-02-23 05:23:17',NULL),(29,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','157.47.153.213','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/login','POST','2020-02-23 05:24:14','2020-02-23 05:24:14',NULL),(30,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','157.47.188.197','Mozilla/5.0 (Linux; Android 10; motorola one power Build/QPTS30.61-18-2; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.117 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-23 15:18:31','2020-02-23 15:18:31',NULL),(31,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','157.47.188.197','Mozilla/5.0 (Linux; Android 10; motorola one power Build/QPTS30.61-18-2; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.117 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-23 15:18:51','2020-02-23 15:18:51',NULL),(32,'Locked Out','Guest',NULL,'https://amarsuperhardtools.com/login','157.47.188.197','Mozilla/5.0 (Linux; Android 10; motorola one power Build/QPTS30.61-18-2; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.117 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-23 15:20:15','2020-02-23 15:20:15',NULL),(33,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','157.47.188.197','Mozilla/5.0 (Linux; Android 10; motorola one power Build/QPTS30.61-18-2; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.117 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-23 15:21:17','2020-02-23 15:21:17',NULL),(34,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','157.47.188.197','Mozilla/5.0 (Linux; Android 10; motorola one power Build/QPTS30.61-18-2; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.117 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-23 15:21:55','2020-02-23 15:21:55',NULL),(35,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','157.47.188.197','Mozilla/5.0 (Linux; Android 10; motorola one power Build/QPTS30.61-18-2; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.117 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-23 17:07:44','2020-02-23 17:07:44',NULL),(36,'Logged In','Registered',3,'https://amarsuperhardtools.com/login','157.47.188.197','Mozilla/5.0 (Linux; Android 9; vivo 1901 Build/PPR1.180610.011; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/74.0.3729.136 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-23 17:15:38','2020-02-23 17:15:38',NULL),(37,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','157.47.188.197','Mozilla/5.0 (Linux; Android 10; motorola one power Build/QPTS30.61-18-2; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.117 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-23 17:47:43','2020-02-23 17:47:43',NULL),(38,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','157.47.188.197','Mozilla/5.0 (Linux; Android 10; motorola one power Build/QPTS30.61-18-2; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.117 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-23 17:48:09','2020-02-23 17:48:09',NULL),(39,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','157.47.188.197','Mozilla/5.0 (Linux; Android 10; motorola one power Build/QPTS30.61-18-2; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.117 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-23 19:54:09','2020-02-23 19:54:09',NULL),(40,'Logged In','Registered',3,'https://amarsuperhardtools.com/login','223.189.129.237','Mozilla/5.0 (Linux; Android 9; vivo 1901 Build/PPR1.180610.011; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/74.0.3729.136 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-24 01:57:10','2020-02-24 01:57:10',NULL),(41,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','157.37.180.72','Mozilla/5.0 (Linux; Android 10; motorola one power Build/QPTS30.61-18-2; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.117 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-24 02:16:30','2020-02-24 02:16:30',NULL),(42,'Logged In','Registered',4,'https://amarsuperhardtools.com/login','157.37.180.72','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/login','POST','2020-02-24 02:58:43','2020-02-24 02:58:43',NULL),(43,'Logged Out','Registered',4,'https://amarsuperhardtools.com/admin/password/post_expired','157.37.180.72','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/admin/password/expired','POST','2020-02-24 03:02:39','2020-02-24 03:02:39',NULL),(44,'Logged In','Registered',4,'https://amarsuperhardtools.com/login','157.37.180.72','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/login','POST','2020-02-24 03:03:14','2020-02-24 03:03:14',NULL),(45,'Logged In','Registered',4,'https://amarsuperhardtools.com/login','223.238.128.150','Mozilla/5.0 (Linux; Android 8.0.0; SM-J600G Build/R16NW; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','en-GB,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-24 03:06:12','2020-02-24 03:06:12',NULL),(46,'Logged Out','Registered',4,'https://amarsuperhardtools.com/logout','157.37.180.72','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/admin/home','POST','2020-02-24 03:06:50','2020-02-24 03:06:50',NULL),(47,'Logged In','Registered',4,'https://amarsuperhardtools.com/login','223.238.128.150','Mozilla/5.0 (Linux; Android 8.0.0; SM-J600G Build/R16NW; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','en-GB,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-24 03:09:56','2020-02-24 03:09:56',NULL),(48,'Logged In','Registered',3,'https://amarsuperhardtools.com/login','223.189.148.8','Mozilla/5.0 (Linux; Android 9; vivo 1901 Build/PPR1.180610.011; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/74.0.3729.136 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-24 06:42:40','2020-02-24 06:42:40',NULL),(49,'Logged In','Registered',2,'https://amarsuperhardtools.com/login','157.37.115.254','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/login','POST','2020-02-24 09:27:22','2020-02-24 09:27:22',NULL),(50,'Logged Out','Registered',2,'https://amarsuperhardtools.com/admin/password/post_expired','157.37.9.244','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/admin/password/expired','POST','2020-02-24 09:30:16','2020-02-24 09:30:16',NULL),(51,'Logged In','Registered',2,'https://amarsuperhardtools.com/login','157.37.115.254','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/login','POST','2020-02-24 09:30:35','2020-02-24 09:30:35',NULL),(52,'Logged Out','Registered',2,'https://amarsuperhardtools.com/logout','157.37.9.244','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/admin/home','POST','2020-02-24 09:32:55','2020-02-24 09:32:55',NULL),(53,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','223.238.151.94','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-24 09:37:34','2020-02-24 09:37:34',NULL),(54,'Logged In','Registered',2,'https://amarsuperhardtools.com/login','223.238.151.94','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-24 09:38:14','2020-02-24 09:38:14',NULL),(55,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','223.238.151.22','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-24 12:39:24','2020-02-24 12:39:24',NULL),(56,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','223.238.151.22','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-24 12:43:52','2020-02-24 12:43:52',NULL),(57,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','223.238.151.22','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-24 12:44:54','2020-02-24 12:44:54',NULL),(58,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','223.238.151.22','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-24 12:45:41','2020-02-24 12:45:41',NULL),(59,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','49.15.64.116','Mozilla/5.0 (Linux; Android 10; motorola one power Build/QPTS30.61-18-2; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.117 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-25 00:15:14','2020-02-25 00:15:14',NULL),(60,'Logged In','Registered',3,'https://amarsuperhardtools.com/login','223.189.148.8','Mozilla/5.0 (Linux; Android 9; vivo 1901 Build/PPR1.180610.011; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/74.0.3729.136 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-25 01:31:51','2020-02-25 01:31:51',NULL),(61,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','47.30.167.33','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/login','POST','2020-02-25 02:55:38','2020-02-25 02:55:38',NULL),(62,'Logged In','Registered',3,'https://amarsuperhardtools.com/login','223.189.148.8','Mozilla/5.0 (Linux; Android 9; vivo 1901 Build/PPR1.180610.011; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/74.0.3729.136 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-25 08:03:59','2020-02-25 08:03:59',NULL),(63,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','1.187.252.184','Mozilla/5.0 (Linux; Android 10; motorola one power Build/QPTS30.61-18-2; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.117 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-25 08:29:44','2020-02-25 08:29:44',NULL),(64,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','27.63.117.212','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-25 08:49:48','2020-02-25 08:49:48',NULL),(65,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','27.63.117.212','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-25 08:51:33','2020-02-25 08:51:33',NULL),(66,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','27.63.117.212','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-25 09:01:16','2020-02-25 09:01:16',NULL),(67,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','27.63.117.212','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-25 09:02:35','2020-02-25 09:02:35',NULL),(68,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','27.63.117.212','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-25 09:05:11','2020-02-25 09:05:11',NULL),(69,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','27.63.117.212','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-25 09:09:32','2020-02-25 09:09:32',NULL),(70,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','27.63.117.212','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-25 09:11:22','2020-02-25 09:11:22',NULL),(71,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','27.63.117.212','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-25 09:13:49','2020-02-25 09:13:49',NULL),(72,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','27.63.117.212','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-25 09:19:08','2020-02-25 09:19:08',NULL),(73,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','27.63.117.212','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-25 09:19:48','2020-02-25 09:19:48',NULL),(74,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','27.63.117.212','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-25 09:23:25','2020-02-25 09:23:25',NULL),(75,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','27.63.117.212','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-25 09:28:50','2020-02-25 09:28:50',NULL),(76,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','27.63.117.212','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-25 10:20:46','2020-02-25 10:20:46',NULL),(77,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','27.63.117.212','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-25 10:22:41','2020-02-25 10:22:41',NULL),(78,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','27.63.117.212','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-25 10:25:11','2020-02-25 10:25:11',NULL),(79,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','27.63.117.212','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-25 10:25:49','2020-02-25 10:25:49',NULL),(80,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','47.31.74.88','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/login','POST','2020-02-25 13:23:41','2020-02-25 13:23:41',NULL),(81,'Logged In','Registered',3,'https://amarsuperhardtools.com/login','223.189.131.148','Mozilla/5.0 (Linux; Android 9; vivo 1901 Build/PPR1.180610.011; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/74.0.3729.136 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-26 01:51:40','2020-02-26 01:51:40',NULL),(82,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','47.31.183.28','Mozilla/5.0 (Linux; Android 10; motorola one power Build/QPTS30.61-18-2; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.117 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-26 03:14:14','2020-02-26 03:14:14',NULL),(83,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','47.31.183.28','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/login','POST','2020-02-26 03:16:11','2020-02-26 03:16:11',NULL),(84,'Logged In','Registered',4,'https://amarsuperhardtools.com/login','27.63.69.100','Mozilla/5.0 (Linux; Android 8.0.0; SM-J600G Build/R16NW; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','en-GB,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-26 05:22:48','2020-02-26 05:22:48',NULL),(85,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','47.31.183.28','Mozilla/5.0 (Linux; Android 10; motorola one power Build/QPTS30.61-18-2; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.117 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-26 06:10:18','2020-02-26 06:10:18',NULL),(86,'Logged In','Registered',2,'https://amarsuperhardtools.com/login','27.63.106.104','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-26 08:05:42','2020-02-26 08:05:42',NULL),(87,'Logged In','Registered',3,'https://amarsuperhardtools.com/login','223.189.129.249','Mozilla/5.0 (Linux; Android 9; vivo 1901 Build/PPR1.180610.011; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/74.0.3729.136 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-26 08:24:29','2020-02-26 08:24:29',NULL),(88,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','106.79.55.243','Mozilla/5.0 (Linux; Android 10; motorola one power) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.119 Mobile Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/login','POST','2020-02-26 08:43:01','2020-02-26 08:43:01',NULL),(89,'Logged Out','Registered',1,'https://amarsuperhardtools.com/logout','106.79.55.243','Mozilla/5.0 (Linux; Android 10; motorola one power) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.119 Mobile Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/admin/roles','POST','2020-02-26 08:44:56','2020-02-26 08:44:56',NULL),(90,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','27.63.95.116','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-26 08:56:01','2020-02-26 08:56:01',NULL),(91,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','27.63.95.116','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-26 08:59:58','2020-02-26 08:59:58',NULL),(92,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','27.63.95.116','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-26 09:36:04','2020-02-26 09:36:04',NULL),(93,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','27.63.69.148','Mozilla/5.0 (Linux; Android 8.0.0; SM-J600G Build/R16NW; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','en-GB,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-26 09:37:31','2020-02-26 09:37:31',NULL),(94,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','27.63.69.148','Mozilla/5.0 (Linux; Android 8.0.0; SM-J600G Build/R16NW; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','en-GB,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-26 10:21:52','2020-02-26 10:21:52',NULL),(95,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','27.63.69.148','Mozilla/5.0 (Linux; Android 8.0.0; SM-J600G Build/R16NW; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','en-GB,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-26 10:22:35','2020-02-26 10:22:35',NULL),(96,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','106.79.55.243','Mozilla/5.0 (Linux; Android 10; motorola one power) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.119 Mobile Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/login','POST','2020-02-26 10:46:42','2020-02-26 10:46:42',NULL),(97,'Logged Out','Registered',1,'https://amarsuperhardtools.com/logout','106.79.55.243','Mozilla/5.0 (Linux; Android 10; motorola one power) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.119 Mobile Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/admin/home','POST','2020-02-26 10:47:04','2020-02-26 10:47:04',NULL),(98,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','223.238.167.250','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-26 12:35:52','2020-02-26 12:35:52',NULL),(99,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','223.238.167.250','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-26 12:37:30','2020-02-26 12:37:30',NULL),(100,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','223.238.167.250','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-26 12:38:46','2020-02-26 12:38:46',NULL),(101,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','47.31.105.213','Mozilla/5.0 (Linux; Android 10; motorola one power Build/QPTS30.61-18-2; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.119 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-26 18:04:19','2020-02-26 18:04:19',NULL),(102,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','106.67.117.29','Mozilla/5.0 (Linux; Android 10; motorola one power Build/QPTS30.61-18-2; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.119 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-26 18:19:19','2020-02-26 18:19:19',NULL),(103,'Logged In','Registered',3,'https://amarsuperhardtools.com/login','223.189.144.33','Mozilla/5.0 (Linux; Android 9; vivo 1901 Build/PPR1.180610.011; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/74.0.3729.136 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-27 01:47:32','2020-02-27 01:47:32',NULL),(104,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','47.31.108.150','Mozilla/5.0 (Linux; Android 10; motorola one power Build/QPTS30.61-18-2; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.119 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-27 06:27:44','2020-02-27 06:27:44',NULL),(105,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','47.31.108.150','Mozilla/5.0 (Linux; Android 10; motorola one power Build/QPTS30.61-18-2; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.119 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-27 06:37:42','2020-02-27 06:37:42',NULL),(106,'Logged In','Registered',3,'https://amarsuperhardtools.com/login','223.189.144.33','Mozilla/5.0 (Linux; Android 9; vivo 1901 Build/PPR1.180610.011; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/74.0.3729.136 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-27 07:06:08','2020-02-27 07:06:08',NULL),(107,'Logged In','Registered',3,'https://amarsuperhardtools.com/login','223.189.144.33','Mozilla/5.0 (Linux; Android 9; vivo 1901 Build/PPR1.180610.011; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/74.0.3729.136 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-27 07:08:29','2020-02-27 07:08:29',NULL),(108,'Logged In','Registered',3,'https://amarsuperhardtools.com/login','223.189.144.33','Mozilla/5.0 (Linux; Android 9; vivo 1901 Build/PPR1.180610.011; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/74.0.3729.136 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-27 07:13:09','2020-02-27 07:13:09',NULL),(109,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','223.238.152.174','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-27 07:44:00','2020-02-27 07:44:00',NULL),(110,'Logged In','Registered',2,'https://amarsuperhardtools.com/login','27.63.88.102','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-27 07:45:40','2020-02-27 07:45:40',NULL),(111,'Logged In','Registered',3,'https://amarsuperhardtools.com/login','223.189.149.42','Mozilla/5.0 (Linux; Android 9; vivo 1901 Build/PPR1.180610.011; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/74.0.3729.136 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-27 08:08:43','2020-02-27 08:08:43',NULL),(112,'Logged In','Registered',4,'https://amarsuperhardtools.com/login','223.238.137.251','Mozilla/5.0 (Linux; Android 8.0.0; SM-J600G Build/R16NW; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','en-GB,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-27 10:50:02','2020-02-27 10:50:02',NULL),(113,'Logged In','Registered',4,'https://amarsuperhardtools.com/login','223.238.137.251','Mozilla/5.0 (Linux; Android 8.0.0; SM-J600G Build/R16NW; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','en-GB,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-27 10:52:55','2020-02-27 10:52:55',NULL),(114,'Logged In','Registered',4,'https://amarsuperhardtools.com/login','27.63.74.35','Mozilla/5.0 (Linux; Android 8.0.0; SM-J600G Build/R16NW; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','en-GB,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-27 10:54:11','2020-02-27 10:54:11',NULL),(115,'Logged In','Registered',4,'https://amarsuperhardtools.com/login','223.189.149.120','Mozilla/5.0 (Linux; Android 8.0.0; SM-J600G Build/R16NW; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','en-GB,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-27 12:15:17','2020-02-27 12:15:17',NULL),(116,'Logged In','Registered',4,'https://amarsuperhardtools.com/login','223.189.149.120','Mozilla/5.0 (Linux; Android 8.0.0; SM-J600G Build/R16NW; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','en-GB,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-27 12:16:32','2020-02-27 12:16:32',NULL),(117,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','47.31.116.85','Mozilla/5.0 (Linux; Android 10; motorola one power Build/QPTS30.61-18-2; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.119 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-27 17:31:49','2020-02-27 17:31:49',NULL),(118,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','47.31.116.85','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/login','POST','2020-02-27 17:34:45','2020-02-27 17:34:45',NULL),(119,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','47.31.116.85','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/login','POST','2020-02-27 17:49:38','2020-02-27 17:49:38',NULL),(120,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','47.30.175.220','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/login','POST','2020-02-28 06:26:28','2020-02-28 06:26:28',NULL),(121,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','47.30.175.220','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/login','POST','2020-02-28 06:36:16','2020-02-28 06:36:16',NULL),(122,'Logged In','Registered',3,'https://amarsuperhardtools.com/login','223.189.130.9','Mozilla/5.0 (Linux; Android 9; vivo 1901 Build/PPR1.180610.011; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/74.0.3729.136 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-28 08:03:44','2020-02-28 08:03:44',NULL),(123,'Logged In','Registered',3,'https://amarsuperhardtools.com/login','223.189.130.9','Mozilla/5.0 (Linux; Android 9; vivo 1901 Build/PPR1.180610.011; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/74.0.3729.136 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-28 08:08:42','2020-02-28 08:08:42',NULL),(124,'Logged In','Registered',3,'https://amarsuperhardtools.com/login','223.189.130.9','Mozilla/5.0 (Linux; Android 9; vivo 1901 Build/PPR1.180610.011; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/74.0.3729.136 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-28 08:24:13','2020-02-28 08:24:13',NULL),(125,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','223.238.199.117','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-28 14:29:34','2020-02-28 14:29:34',NULL),(126,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','223.238.199.117','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-28 14:31:35','2020-02-28 14:31:35',NULL),(127,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','223.238.199.117','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-28 14:32:54','2020-02-28 14:32:54',NULL),(128,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','223.238.199.117','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-28 14:34:38','2020-02-28 14:34:38',NULL),(129,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','47.30.223.155','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/login','POST','2020-02-28 20:43:53','2020-02-28 20:43:53',NULL),(130,'Logged Out','Registered',1,'https://amarsuperhardtools.com/logout','47.30.223.155','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/admin/home','POST','2020-02-28 20:47:03','2020-02-28 20:47:03',NULL),(131,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','47.30.223.155','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/login','POST','2020-02-28 20:47:25','2020-02-28 20:47:25',NULL),(132,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','106.67.115.60','Mozilla/5.0 (Linux; Android 10; motorola one power Build/QPTS30.61-18-3; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.119 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-28 20:49:37','2020-02-28 20:49:37',NULL),(133,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','47.30.223.155','Mozilla/5.0 (Linux; Android 10; motorola one power Build/QPTS30.61-18-3; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.119 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-02-28 21:46:08','2020-02-28 21:46:08',NULL),(134,'Logged In','Registered',2,'https://amarsuperhardtools.com/login','223.238.202.126','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-03-01 06:18:22','2020-03-01 06:18:22',NULL),(135,'Logged In','Registered',2,'https://amarsuperhardtools.com/login','223.238.202.126','Mozilla/5.0 (Linux; Android 8.1.0; CPH1909 Build/O11019; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','hi-IN,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-03-01 06:25:41','2020-03-01 06:25:41',NULL),(136,'Failed Login Attempt','Guest',NULL,'https://amarsuperhardtools.com/login','171.79.191.164','Mozilla/5.0 (Linux; Android 8.0.0; SM-J600G Build/R16NW; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/69.0.3497.100 Mobile Safari/537.36','en-GB,en-US;q=0.9','https://amarsuperhardtools.com/login','POST','2020-03-04 14:52:47','2020-03-04 14:52:47',NULL),(137,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','47.30.152.16','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/login','POST','2020-03-05 01:40:06','2020-03-05 01:40:06',NULL),(138,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','47.30.152.16','Mozilla/5.0 (Linux; Android 10; motorola one power Build/QPTS30.61-18-3; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.119 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-03-05 04:49:39','2020-03-05 04:49:39',NULL),(139,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','47.30.152.16','Mozilla/5.0 (Linux; Android 10; motorola one power Build/QPTS30.61-18-3; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.119 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-03-05 05:18:16','2020-03-05 05:18:16',NULL),(140,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','157.47.201.20','Mozilla/5.0 (Linux; Android 10; motorola one power Build/QPTS30.61-18-3; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.119 Mobile Safari/537.36','en-US,en;q=0.9','https://amarsuperhardtools.com/login','POST','2020-03-06 19:19:14','2020-03-06 19:19:14',NULL),(141,'Logged In','Registered',1,'https://amarsuperhardtools.com/login','157.37.232.178','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36','en-GB,en-US;q=0.9,en;q=0.8','https://amarsuperhardtools.com/login','POST','2020-03-07 01:26:33','2020-03-07 01:26:33',NULL);
/*!40000 ALTER TABLE `laravel_logger_activity` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `media`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `media` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `model_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `collection_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `disk` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` bigint(20) unsigned NOT NULL,
  `manipulations` json NOT NULL,
  `custom_properties` json NOT NULL,
  `responsive_images` json NOT NULL,
  `order_column` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_model_type_model_id_index` (`model_type`,`model_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `media` WRITE;
/*!40000 ALTER TABLE `media` DISABLE KEYS */;
/*!40000 ALTER TABLE `media` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2014_10_00_000000_create_settings_table',1),(2,'2014_10_00_000001_add_group_column_on_settings_table',1),(3,'2014_10_12_000000_create_users_table',1),(4,'2014_10_12_100000_create_password_resets_table',1),(5,'2016_01_15_105324_create_roles_table',1),(6,'2016_01_15_114412_create_role_user_table',1),(7,'2016_01_26_115212_create_permissions_table',1),(8,'2016_01_26_115523_create_permission_role_table',1),(9,'2016_02_09_132439_create_permission_user_table',1),(10,'2016_06_01_000001_create_oauth_auth_codes_table',1),(11,'2016_06_01_000002_create_oauth_access_tokens_table',1),(12,'2016_06_01_000003_create_oauth_refresh_tokens_table',1),(13,'2016_06_01_000004_create_oauth_clients_table',1),(14,'2016_06_01_000005_create_oauth_personal_access_clients_table',1),(15,'2017_11_04_103444_create_laravel_logger_activity_table',1),(16,'2017_12_09_070937_create_two_step_auth_table',1),(17,'2019_08_19_000000_create_failed_jobs_table',1),(18,'2019_10_11_202649_create_bond_process_params_table',1),(19,'2019_10_11_212510_create_bonds_table',1),(20,'2019_10_11_215559_create_unit_table',1),(21,'2019_10_11_220404_create_bond_material_recipes_table',1),(22,'2019_10_11_221619_create_bond_recipe_productions_table',1),(23,'2019_10_11_224143_create_production_packagings_table',1),(24,'2019_10_11_224617_create_production_packaging_details',1),(25,'2019_10_13_040345_create_consumable_settings_table',1),(26,'2019_10_13_070026_create_consumable_detail',1),(27,'2019_10_13_192625_create_consumable_categories_table',1),(28,'2019_10_13_193116_create_consumable_items_table',1),(29,'2019_10_15_181919_create_bond_process_consumable_detail',1),(30,'2019_11_09_175816_create_bond_design',1),(31,'2019_11_10_172356_create_bond_recipe_production_status',1),(32,'2019_11_18_184517_create_account_groups_table',1),(33,'2019_11_18_184959_create_accounts_table',1),(34,'2019_11_26_033550_create_entry_types_table',1),(35,'2019_11_26_035201_create_entries_table',1),(36,'2019_11_26_043142_create_bond_invoices_table',1),(37,'2019_12_10_043557_create_password_securities',1),(38,'2019_12_17_034813_create_quality_checks_table',1),(39,'2019_12_19_044050_create_consumable_consumpations_table',1),(40,'2019_12_24_084509_create_production_status',1),(41,'2020_01_03_055154_create_bond_products_table',1),(42,'2020_01_14_154432_create_bond_product_type',1),(43,'2020_01_22_035741_create_entry_tags_table',1),(44,'2020_01_26_183742_create_production_view',1),(45,'2020_01_26_215310_create_stock_view',1),(46,'2020_01_26_230258_create_media_table',1),(47,'2020_01_28_011734_create_company_detail',1),(48,'2020_02_09_163135_create_accounts_view',1),(49,'2020_02_11_183251_create_consumable_view',2),(50,'2020_02_14_050425_create_printer_template',2),(51,'2020_02_27_220554_update_table_foreign_key',3),(52,'2020_03_01_222730_update_company_detail',4),(53,'2020_03_05_070913_update_packing_detail',4),(54,'2020_03_06_234404_create_employee_table',4),(55,'2020_03_06_234836_create_employees_table',4),(56,'2020_03_06_235257_update_bond_recipe_production_detail',4);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_access_tokens` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `scopes` text COLLATE utf8mb4_unicode_ci,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_access_tokens_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_access_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_access_tokens` DISABLE KEYS */;
INSERT INTO `oauth_access_tokens` VALUES ('1ae7047281e66fc59888229caafd636e37693d7397aff056316b2e56fcb1f076b0a37d82c53b6f75',3,1,NULL,'[]',0,'2020-03-06 13:39:10','2020-03-06 13:39:10','2020-03-07 19:09:10'),('53b9afbddc1b04e661cca89ac3a80234fb0bb467f660aa6e5fa3109a5bf038fc3a6315910b165688',2,1,NULL,'[]',0,'2020-03-05 11:43:24','2020-03-05 11:43:24','2020-03-06 17:13:24'),('7a9e918bb067c6ecf2d5513a1c0151f821dba4c1007d2507d6b8c145ddcce342b0b02b933cf2c3d4',1,1,NULL,'[]',0,'2020-03-06 19:19:32','2020-03-06 19:19:32','2020-03-08 00:49:32'),('9534347e2adc8952c30adf2afe155207c34b166f0626e92cc311ea267f1c20722d62f42e8715438e',4,1,NULL,'[]',0,'2020-02-27 12:16:34','2020-02-27 12:16:34','2020-02-28 17:46:34');
/*!40000 ALTER TABLE `oauth_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_auth_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_auth_codes` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `scopes` text COLLATE utf8mb4_unicode_ci,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_auth_codes` WRITE;
/*!40000 ALTER TABLE `oauth_auth_codes` DISABLE KEYS */;
INSERT INTO `oauth_auth_codes` VALUES ('0106affedc7fb3e2e393eb692d10a2fee135d7bc864b1e8577bbf9c47399097e64982ed97270047e',3,1,'[\"*\"]',1,'2020-02-25 01:42:21'),('021aaf47dc30ac536ce7b30cb2b1c38e6b83bea416d4af940d086f9e1397abf26293ddda11c6bddb',1,1,'[\"*\"]',1,'2020-02-29 03:08:13'),('03687b70ec1fc7ccfcb42b8505e38fac114babfe3c3e65a4e8942323ba509647db0d8d9cd1334f32',3,1,'[\"*\"]',1,'2020-02-28 14:04:29'),('039d48db8979f228a975ca4ac888e8a41c4b9cadc44dc85c965aaedc1427b28a05d4d27f5cf62ea2',4,1,'[\"*\"]',1,'2020-02-27 16:30:03'),('04a5ac76d59cf229f51d6afde9d07585855347839ccc2e7868ef4ea0a3d654e408ab1a06fa1a730a',1,1,'[\"*\"]',1,'2020-02-25 08:40:14'),('07e81cfe322500202ce7073ddddb3b11d0a43145abf91072bfd41a8eb9f76691e21bc6fad6daee1e',1,1,'[\"*\"]',1,'2020-02-27 23:12:03'),('115950aa6a82bd1d0c685b8a9c7e1341605d66e08bf0396187d3d257e86a6815015bdefe6f702d9a',3,1,'[\"*\"]',1,'2020-02-23 17:26:06'),('15a6bd52c298d5c324c5d9ed583c5856f37228c3c7f4752591ed9e5f50f76c1114b178371ea0115a',1,1,'[\"*\"]',1,'2020-02-22 10:01:08'),('20dbbe65b670e630514219e6142f73688d2bbd9cb30088c47a70bc631498e76d7ac1da4c6388a2f9',1,1,'[\"*\"]',1,'2020-02-26 08:54:29'),('22ca592ba354d3e5f794f3d9ed449884daded51c891997b7d8d75945ee94e9f580211e1e10193a47',3,1,'[\"*\"]',1,'2020-02-23 02:10:06'),('25685ce6ba10b86ae5b1e949c8794bcda3ea87a2aeec3b5dedaf1397fac9078907a3a81eb243e14e',2,1,'[\"*\"]',1,'2020-02-23 05:33:30'),('25d76ddaf3b2d883cbf8265fd24ddc8ca50832baddc9352ff6899c7d49b43cd6b99b60eca84ab8a5',1,1,'[\"*\"]',1,'2020-02-23 01:45:01'),('26c6a6885c3bb81eb5c9a829a77fda39c247e61824b8bac74303f25bd282cdc4e590b184a23fd54b',1,1,'[\"*\"]',1,'2020-02-29 02:25:05'),('2b68aad2803e2c0c9a86e1a5699dc8cecdd823316b695358459d7f0673bac1e16a538a62952c6bd2',1,1,'[\"*\"]',1,'2020-02-23 17:18:22'),('2d17446b68affb3abeb7b65c4f0fd35de04575575043b6ad8e59b42814660f6041f0a39e84920f67',1,1,'[\"*\"]',1,'2020-02-23 20:04:22'),('2d302c4f2bcb852d8dda2c750e09dee75d24ef9f2413fd7b69b87864309c97afe7fdb01a05fe5538',3,1,'[\"*\"]',1,'2020-02-27 13:49:00'),('335599b2a61af4989ecee4b2f8b5f9e363f2ee189d33653991e6907bb4ccf37d1e3dbf51b8571740',3,1,'[\"*\"]',1,'2020-02-26 14:04:46'),('3cdecd59cf37fd0aece795bb2b5493debe036e9ce1fb18919bd8572b825d54edf030a5323c533704',4,1,'[\"*\"]',1,'2020-02-27 17:55:17'),('4b392478c809a55a759bd46f613a09a6ce04143f33a66440d033a2ce543e92d44afad40826c3885d',1,1,'[\"*\"]',1,'2020-03-05 10:29:53'),('51b87c24d84c60b2b8e89c18a11ee55a0a8ec1087970667083eea1217ddcefa27d9deacf5cfd1034',1,1,'[\"*\"]',1,'2020-02-23 05:23:41'),('559ecc9d70485db24e57e71887aabd5e9204821b5e93e7c2edcf926e65485518e9e17700992349ce',3,1,'[\"*\"]',1,'2020-02-22 05:59:25'),('57279dc89ba80feeb4454a1833cd5a847357296b06b119fbceb2cb856448be390f37df82d628bfc4',2,1,'[\"*\"]',1,'2020-02-26 13:46:12'),('59106467d4a202d492f620b937f2293318d0c95d140b2ec85b4158955bcdd5975718be936b0cf2ba',3,1,'[\"*\"]',1,'2020-02-23 00:32:56'),('5de41bc748a4d32af31455889d0c8021214db8fb1b059c2094702ae8cc5e1b15386a0b35795a9938',1,1,'[\"*\"]',1,'2020-02-25 00:26:01'),('68c08418d7f0a628e970bc119d0dd8006592fe8819267edcb98da294003052a37e8120b4684eb65e',3,1,'[\"*\"]',1,'2020-02-27 12:46:33'),('793024b89746a39f64c84d8238291496496c6b2a1a657f5c17fd2709eb0149588b86d2db78da4256',3,1,'[\"*\"]',1,'2020-02-28 13:44:01'),('7aa67beeb838866a2725927b6b0cc40d06f5f877b76bd2693bd0a008e62a8981e085e0c21f9e1575',1,1,'[\"*\"]',1,'2020-02-29 03:26:21'),('7e931896192cf57d81f05acaa560bcd95961f7cb27424b9bf5cb040cd35a08ab463f25422e820f85',4,1,'[\"*\"]',1,'2020-02-24 03:16:12'),('89d876dc87a4ed7d9f1b9dda18c854baa6b28ba49eee01bc3ee5cc6100cbb15682e9c9994ba34be5',4,1,'[\"*\"]',1,'2020-02-24 03:19:56'),('8ad11ffdf47e8750af85a69f3d1df44f3f03ad94a057be57e461d9c8749d9a434cf5d36e893ebfab',3,1,'[\"*\"]',1,'2020-02-24 02:07:29'),('94bee9c89e91dec42d128413fb70e3454b523a5c24cdf584d6b7bb1d023eacb18db4ee6a5c640310',1,1,'[\"*\"]',1,'2020-03-07 00:59:31'),('b118af04eaf9c89cd719dd36587e177bf76e8e5cbf79d8b5a7b52ead4ced5788e1d75740549ce37d',1,1,'[\"*\"]',1,'2020-02-24 02:26:47'),('b143b16bd63e3d01f7988ec351e5b87af4819c63deb0922985d81ac20c372eaab11f8f967c9fc429',1,1,'[\"*\"]',1,'2020-02-29 02:29:50'),('b59b8e376ea2c4b6a69393235ec56846fed83b9cf19bc0af14b61ed520242d5402b9043a9e68bf5d',2,1,'[\"*\"]',1,'2020-02-27 13:25:59'),('b5d5cdb6ea951f8f3ec8f8d619b4f4ff8f3ea54f4265acd63346939c026f07f0aa429d805af14981',4,1,'[\"*\"]',1,'2020-02-27 16:32:55'),('b5fa12493623bcc3b065d6e67395e5f3c2b2961b0ac2c69a31222d88a35c41e62d50aded08946762',3,1,'[\"*\"]',1,'2020-02-26 07:31:58'),('bfbadea91515ff880063e39562e5d97e0eb519dda6bc3a92a28e378aefe93129378d5483cb12e2c9',3,1,'[\"*\"]',1,'2020-02-27 07:27:49'),('c26a8236742659b585a4158596d3de56ce8e67d5f0339347f023deadd22038513bc071d596145e9d',2,1,'[\"*\"]',1,'2020-02-24 09:48:36'),('c4ccc4a43121263992782789b472eeb880236fd8167002cc9611f68ff9f720411c939c24ef8ebda6',1,1,'[\"*\"]',1,'2020-02-14 19:21:10'),('c668d7d55570a8b9b0fd3c68ecd36361eb18a38c15389c78c40454fa102f9ff2389aafb4f5ae853c',1,1,'[\"*\"]',1,'2020-02-26 23:44:33'),('c797ddd086cb1609aa0af6688bc3ddb4cf07ac33b02bac975de71790735fc5ea097006093670b35f',1,1,'[\"*\"]',1,'2020-02-23 17:58:22'),('cefb47999ae6ee1fa89b0bece5219ad34aa00aa2c92ec59e6083aecf3cf50874e485a248c22c9781',1,1,'[\"*\"]',1,'2020-02-27 12:07:57'),('d67165921089c2386a35a78c4d67afdf1bd863620e27b824494f4cac3022bc5785b8ab49f92f2326',1,1,'[\"*\"]',1,'2020-02-25 03:05:57'),('d769defb8749e318a14ee7564c10032a4a3a74e651542417fc2a84e5cb87a03f4b5e8f9a3f5fc1b8',4,1,'[\"*\"]',1,'2020-02-27 16:34:11'),('d9772b9b6daf1d5d15ab70eba89a93079745485ee9cddb7370befab193bc08752e4892f8923bc3b4',1,1,'[\"*\"]',1,'2020-02-26 11:50:33'),('de6de74e53ef51468755f33adab7e089b08367b6fbb3ad9207db4abe1465dfc74bfca7175485dab8',1,1,'[\"*\"]',1,'2020-02-23 15:32:10'),('efdd0a14c0835db7cb7b63fae616b61d5a3ffe368f73b937e3016cc10a14635721a4ecb88e836b57',1,1,'[\"*\"]',1,'2020-03-05 10:58:29'),('f205b2f9399e753b23b1f1a3e0c938d80ee676c4163cca136689e4568f89950af7b3554edfeae396',4,1,'[\"*\"]',1,'2020-02-27 17:56:32'),('f354bc380b0596ffd6f0084910bf0b29f36f4f3f848f28b4fce6aca9d392f62bb02eadf3cde4ca89',2,1,'[\"*\"]',1,'2020-03-01 11:58:45'),('f444d3d2ff51458b81da92387e64f74498d82dcc97f3b1f7e00ccee3726802f2b1b46de94386e5ab',4,1,'[\"*\"]',1,'2020-02-26 11:02:49'),('f6276d76d1e2d0c2fdfd89fa8aa12a47bb84c94454b89b3fa57d4d011059e6881f393dd6624c4197',3,1,'[\"*\"]',1,'2020-02-24 06:53:07'),('fb0c5ad129908518fe54d3e45213b8e0e4fe651e7e343fe3e86601bedaddc4269b515099d069f813',1,1,'[\"*\"]',1,'2020-02-29 02:27:40');
/*!40000 ALTER TABLE `oauth_auth_codes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `redirect` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `personal_access_client` tinyint(1) NOT NULL,
  `password_client` tinyint(1) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_clients_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_clients` WRITE;
/*!40000 ALTER TABLE `oauth_clients` DISABLE KEYS */;
INSERT INTO `oauth_clients` VALUES (1,NULL,'mobile','vSIqEamfwpgpgEeT73Redx5IxbrmKqTukfYpRYU2','https://amarsuperhardtools.com/callback',0,0,0,'2020-02-14 17:49:09','2020-02-14 17:49:09');
/*!40000 ALTER TABLE `oauth_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_personal_access_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_personal_access_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `client_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_personal_access_clients_client_id_index` (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_personal_access_clients` WRITE;
/*!40000 ALTER TABLE `oauth_personal_access_clients` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_personal_access_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_refresh_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_refresh_tokens` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `access_token_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_refresh_tokens_access_token_id_index` (`access_token_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_refresh_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_refresh_tokens` DISABLE KEYS */;
INSERT INTO `oauth_refresh_tokens` VALUES ('30f7858c3e076b239edc426d2d8db9bec8b7837f49d63acf971c9c66a8a94f36312be6b29f76eed3','1ae7047281e66fc59888229caafd636e37693d7397aff056316b2e56fcb1f076b0a37d82c53b6f75',0,'2020-04-05 19:09:10'),('a65d6d199f5755c860ddea5ba3106a17954b28588fb763509ea859489727a36ef7a9defd452efe7b','7a9e918bb067c6ecf2d5513a1c0151f821dba4c1007d2507d6b8c145ddcce342b0b02b933cf2c3d4',0,'2020-04-06 00:49:32'),('d350041f22709169550ba6352d93ba1b39749dd50d2808aa6b96663cb0f56d8dad0efdcc9f90c985','53b9afbddc1b04e661cca89ac3a80234fb0bb467f660aa6e5fa3109a5bf038fc3a6315910b165688',0,'2020-04-04 17:13:24');
/*!40000 ALTER TABLE `oauth_refresh_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `packed_stock_view`;
/*!50001 DROP VIEW IF EXISTS `packed_stock_view`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE VIEW `packed_stock_view` AS SELECT 
 1 AS `material_id`,
 1 AS `packing_id`,
 1 AS `bond_product`,
 1 AS `bond_name`,
 1 AS `product_type`,
 1 AS `qty`,
 1 AS `unit`*/;
SET character_set_client = @saved_cs_client;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_resets` (
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_securities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_securities` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `google2fa_enable` tinyint(1) NOT NULL DEFAULT '0',
  `google2fa_secret` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_securities` WRITE;
/*!40000 ALTER TABLE `password_securities` DISABLE KEYS */;
INSERT INTO `password_securities` VALUES (1,1,1,'O4DLPAHOA3DOMMKN','2020-02-14 19:09:17','2020-02-14 19:09:43'),(2,3,1,'MTGS3YMZS6N52BOD','2020-02-22 05:07:36','2020-02-22 05:08:19'),(4,4,0,'JTPFSOYHAY4A52DA','2020-02-24 03:03:17','2020-02-24 03:03:17'),(5,2,1,'WLYUASDH2RZRMXLM','2020-02-24 09:30:38','2020-02-24 09:32:39');
/*!40000 ALTER TABLE `password_securities` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permission_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permission_role` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `permission_id` bigint(20) unsigned NOT NULL,
  `role_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `permission_role_permission_id_index` (`permission_id`),
  KEY `permission_role_role_id_index` (`role_id`),
  CONSTRAINT `permission_role_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `permission_role_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=570 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permission_role` WRITE;
/*!40000 ALTER TABLE `permission_role` DISABLE KEYS */;
INSERT INTO `permission_role` VALUES (244,1,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(245,3,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(246,5,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(247,6,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(248,7,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(249,8,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(250,9,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(251,10,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(252,11,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(253,12,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(254,13,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(255,14,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(256,15,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(257,16,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(258,18,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(259,19,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(260,20,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(261,21,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(262,22,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(263,23,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(264,25,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(265,26,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(266,27,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(267,28,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(268,29,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(269,30,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(270,32,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(271,35,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(272,36,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(273,37,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(274,38,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(275,39,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(276,40,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(277,41,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(278,42,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(279,43,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(280,44,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(281,45,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(282,46,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(283,47,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(284,48,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(285,49,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(286,50,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(287,51,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(288,52,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(289,53,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(290,54,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(291,59,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(292,60,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(293,61,2,'2020-02-23 04:49:24','2020-02-23 04:49:24',NULL),(294,62,2,'2020-02-23 04:49:25','2020-02-23 04:49:25',NULL),(295,63,2,'2020-02-23 04:49:25','2020-02-23 04:49:25',NULL),(296,64,2,'2020-02-23 04:49:25','2020-02-23 04:49:25',NULL),(297,66,2,'2020-02-23 04:49:25','2020-02-23 04:49:25',NULL),(298,65,2,'2020-02-23 04:49:25','2020-02-23 04:49:25',NULL),(361,8,3,'2020-02-23 04:50:53','2020-02-23 04:50:53',NULL),(362,12,3,'2020-02-23 04:50:53','2020-02-23 04:50:53',NULL),(363,15,3,'2020-02-23 04:50:53','2020-02-23 04:50:53',NULL),(364,17,3,'2020-02-23 04:50:53','2020-02-23 04:50:53',NULL),(365,19,3,'2020-02-23 04:50:53','2020-02-23 04:50:53',NULL),(366,22,3,'2020-02-23 04:50:53','2020-02-23 04:50:53',NULL),(367,24,3,'2020-02-23 04:50:53','2020-02-23 04:50:53',NULL),(368,26,3,'2020-02-23 04:50:53','2020-02-23 04:50:53',NULL),(369,29,3,'2020-02-23 04:50:53','2020-02-23 04:50:53',NULL),(370,31,3,'2020-02-23 04:50:53','2020-02-23 04:50:53',NULL),(371,35,3,'2020-02-23 04:50:53','2020-02-23 04:50:53',NULL),(372,38,3,'2020-02-23 04:50:53','2020-02-23 04:50:53',NULL),(373,55,3,'2020-02-23 04:50:53','2020-02-23 04:50:53',NULL),(374,59,3,'2020-02-23 04:50:53','2020-02-23 04:50:53',NULL),(375,66,3,'2020-02-23 04:50:53','2020-02-23 04:50:53',NULL),(376,8,5,'2020-02-23 04:52:35','2020-02-23 04:52:35',NULL),(377,29,5,'2020-02-23 04:52:35','2020-02-23 04:52:35',NULL),(378,40,5,'2020-02-23 04:52:35','2020-02-23 04:52:35',NULL),(379,43,5,'2020-02-23 04:52:35','2020-02-23 04:52:35',NULL),(380,45,5,'2020-02-23 04:52:35','2020-02-23 04:52:35',NULL),(381,48,5,'2020-02-23 04:52:35','2020-02-23 04:52:35',NULL),(382,50,5,'2020-02-23 04:52:35','2020-02-23 04:52:35',NULL),(383,53,5,'2020-02-23 04:52:35','2020-02-23 04:52:35',NULL),(384,56,5,'2020-02-23 04:52:35','2020-02-23 04:52:35',NULL),(385,57,5,'2020-02-23 04:52:35','2020-02-23 04:52:35',NULL),(386,58,5,'2020-02-23 04:52:35','2020-02-23 04:52:35',NULL),(387,64,5,'2020-02-23 04:52:35','2020-02-23 04:52:35',NULL),(388,61,5,'2020-02-23 04:52:35','2020-02-23 04:52:35',NULL),(389,62,5,'2020-02-23 04:52:35','2020-02-23 04:52:35',NULL),(390,65,5,'2020-02-23 04:52:35','2020-02-23 04:52:35',NULL),(511,1,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(512,2,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(513,3,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(514,4,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(515,5,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(516,6,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(517,7,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(518,8,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(519,9,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(520,10,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(521,11,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(522,12,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(523,13,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(524,14,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(525,15,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(526,16,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(527,18,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(528,19,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(529,20,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(530,21,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(531,22,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(532,23,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(533,25,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(534,26,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(535,27,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(536,28,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(537,29,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(538,30,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(539,32,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(540,33,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(541,34,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(542,35,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(543,36,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(544,37,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(545,38,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(546,39,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(547,40,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(548,41,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(549,42,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(550,43,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(551,44,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(552,45,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(553,46,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(554,47,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(555,48,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(556,49,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(557,50,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(558,51,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(559,52,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(560,53,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(561,54,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(562,59,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(563,60,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(564,61,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(565,62,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(566,63,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(567,64,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(568,65,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL),(569,66,1,'2020-02-26 08:44:51','2020-02-26 08:44:51',NULL);
/*!40000 ALTER TABLE `permission_role` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permission_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permission_user` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `permission_user_permission_id_index` (`permission_id`),
  KEY `permission_user_user_id_index` (`user_id`),
  CONSTRAINT `permission_user_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `permission_user_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permission_user` WRITE;
/*!40000 ALTER TABLE `permission_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `permission_user` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `model` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `permissions_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES (1,'Can View Users','view.users','Can view users','Permission','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(2,'Can Create Users','create.users','Can create new users','Permission','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(3,'Can Edit Users','edit.users','Can edit users','Permission','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(4,'Can Delete Users','delete.users','Can delete users','Permission','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(5,'Can Create Material','create.bondmaterialrecipes','Can Create Material','BondMaterialRecipe','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(6,'Can Update Material','update.bondmaterialrecipes','Can Update Material','BondMaterialRecipe','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(7,'Can Delete Material','delete.bondmaterialrecipes','Can Update Material','BondMaterialRecipe','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(8,'View Material','view.bondmaterialrecipes','Can View Material','BondMaterialRecipe','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(9,'List Material','list.bondmaterialrecipes','Can Update Material','BondMaterialRecipe','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(10,'Report Material','report.bondmaterialrecipes','Report Material','BondMaterialRecipe','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(11,'Sensitive information','view.sensitive','View Sensitive Information','SensitiveInfo','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(12,'Can Create Production','create.bondrecipeproductions','Can Create Production','BondRecipeProduction','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(13,'Can Update Production','update.bondrecipeproductions','Can Update Production','BondRecipeProduction','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(14,'Can Delete Production','delete.bondrecipeproductions','Can Delete Production','BondRecipeProduction','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(15,'View Production','view.bondrecipeproductions','Can View Production','BondRecipeProduction','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(16,'List Production','list.bondrecipeproductions','Can List Production','BondRecipeProduction','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(17,'Limited List Production','limitlist.bondrecipeproductions','Can limited List Production','BondRecipeProduction','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(18,'Report Production','report.bondrecipeproductions','Report Production','BondRecipeProduction','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(19,'Can Create QualityCheck','create.qualitychecks','Can Create QualityCheck','QualityCheck','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(20,'Can Update QualityCheck','update.qualitychecks','Can Update QualityCheck','QualityCheck','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(21,'Can Delete QualityCheck','delete.qualitychecks','Can Delete QualityCheck','QualityCheck','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(22,'View QualityCheck','view.qualitychecks','Can View QualityCheck','QualityCheck','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(23,'List QualityCheck','list.qualitychecks','Can List QualityCheck','QualityCheck','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(24,'Limited List QualityCheck','limitlist.qualitychecks','Can List QualityCheck','QualityCheck','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(25,'Report QualityCheck','report.qualitychecks','Report QualityCheck','QualityCheck','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(26,'Create Packaging','create.productionpackagings','Can Create Packaging','ProductionPackaging','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(27,'Update Packaging','update.productionpackagings','Can Update PackPackaginging','ProductionPackaging','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(28,'Delete Packaging','delete.productionpackagings','Can Delete Packaging','ProductionPackaging','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(29,'View Packaging','view.productionpackagings','Can View Packaging','ProductionPackaging','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(30,'List Packaging','list.productionpackagings','Can List Packaging','ProductionPackaging','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(31,'Limited Packaging','limitlist.productionpackagings','Can List Packaging','ProductionPackaging','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(32,'Report Packaging','report.productionpackagings','Report Packaging','ProductionPackaging','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(33,'Merge Packaging','merge.productionpackagings','Merge Packaging','ProductionPackaging','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(34,'Divide Packaging','divide.productionpackagings','Divide Packaging','ProductionPackaging','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(35,'Create Consumpation','create.consumableconsumpations','Can Create Consumpation','ConsumableConsumpation','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(36,'Update Consumpation','update.consumableconsumpations','Can Update Consumpation','ConsumableConsumpation','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(37,'Delete Consumpation','delete.consumableconsumpations','Can Delete Consumpation','ConsumableConsumpation','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(38,'View Consumpation','view.consumableconsumpations','Can View Consumpation','ConsumableConsumpation','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(39,'List Consumpation','list.consumableconsumpations','Can List Consumpation','ConsumableConsumpation','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(40,'Create Accounts','create.accounts','Can Create Accounts','Account','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(41,'Update Accounts','update.accounts','Can Update Accounts','Account','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(42,'Delete Accounts','delete.accounts','Can Delete Accounts','Account','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(43,'View Accounts','view.accounts','Can View Accounts','Account','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(44,'List Accounts','list.accounts','Can List Accounts','Account','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(45,'Create Invoice','create.invoices','Can Create Invoice','Invoice','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(46,'Update Invoice','update.invoices','Can Update Invoice','Invoice','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(47,'Delete Invoice','delete.invoices','Can Delete Invoices','Invoice','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(48,'View Invoice','view.invoices','Can View Invoices','Invoice','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(49,'List Invoice','list.invoices','Can List invoices','Invoice','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(50,'Create Entry','create.entries','Can Create Entry','Entry','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(51,'Update Entry','update.entries','Can Update Entry','Entry','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(52,'Delete Entry','delete.entries','Can Delete Entry','Entry','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(53,'View Entry','view.entries','Can View Entry','Entry','2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(54,'List Entry','list.entries','Can List Entry','Entry','2020-02-14 17:52:53','2020-02-14 17:52:53',NULL),(55,'Limit list Consumable Consumpation','limitlist.consumableconsumpation',NULL,'ConsumableConsumpation','2020-02-23 03:23:31','2020-02-23 03:23:31',NULL),(56,'Limit list accounts','limitlist.accounts',NULL,'Account','2020-02-23 03:25:17','2020-02-23 03:25:17',NULL),(57,'Limit list Invoices','limitlist.invoices',NULL,'Invoice','2020-02-23 03:25:50','2020-02-23 03:25:50',NULL),(58,'Limit list Transaction','limitlist.transaction',NULL,'Entry','2020-02-23 03:26:37','2020-02-23 03:26:37',NULL),(59,'Can update production status','update.productionstatus','Can update production status','BondMaterialRecipe','2020-02-23 03:52:20','2020-02-23 03:52:20',NULL),(60,'Can View Account Statement','view.reportaccountstatement','Can See Account Statement','Account','2020-02-23 04:39:36','2020-02-23 04:39:36',NULL),(61,'View Packed Stock','view.reportpackedstock','Can view packed stock','ProductionPackaging','2020-02-23 04:42:03','2020-02-23 04:42:03',NULL),(62,'Can view raw stock','view.reportrawstock','Can view raw stock','QualityCheck','2020-02-23 04:42:35','2020-02-23 04:42:35',NULL),(63,'Can view consumable stock','view.reportconsumablestock','Can view consumable stock','ConsumableConsumpation','2020-02-23 04:44:08','2020-02-23 04:44:08',NULL),(64,'View Accounts Section','view.accountsection','Can view accounts sections in app','Account','2020-02-23 04:45:13','2020-02-23 04:45:13',NULL),(65,'Can view reports section','view.reportsection','Can view report section','Account','2020-02-23 04:45:51','2020-02-23 04:45:51',NULL),(66,'Can view production section','view.productionsection','Can view production section','Account','2020-02-23 04:47:02','2020-02-23 04:47:02',NULL);
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `printer_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `printer_templates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `signature_footer` text COLLATE utf8mb4_unicode_ci,
  `declaration_note` text COLLATE utf8mb4_unicode_ci,
  `bottom_footer` text COLLATE utf8mb4_unicode_ci,
  `top_tag_line` text COLLATE utf8mb4_unicode_ci,
  `bank_detail` text COLLATE utf8mb4_unicode_ci,
  `tnc` text COLLATE utf8mb4_unicode_ci,
  `logo_path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `watermark_path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `printer_templates` WRITE;
/*!40000 ALTER TABLE `printer_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `printer_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `production_packaging_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `production_packaging_detail` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `packing_id` bigint(20) unsigned NOT NULL,
  `material_id` bigint(20) unsigned NOT NULL,
  `qty` decimal(25,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `production_packaging_detail_packing_id_unique` (`packing_id`),
  KEY `production_packaging_detail_created_by_foreign` (`created_by`),
  KEY `production_packaging_detail_updated_by_foreign` (`updated_by`),
  KEY `production_packaging_detail_material_id_foreign` (`material_id`),
  CONSTRAINT `production_packaging_detail_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `production_packaging_detail_material_id_foreign` FOREIGN KEY (`material_id`) REFERENCES `bond_material_recipes` (`material_id`),
  CONSTRAINT `production_packaging_detail_packing_id_foreign` FOREIGN KEY (`packing_id`) REFERENCES `production_packagings` (`packing_id`) ON DELETE CASCADE,
  CONSTRAINT `production_packaging_detail_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=68 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `production_packaging_detail` WRITE;
/*!40000 ALTER TABLE `production_packaging_detail` DISABLE KEYS */;
INSERT INTO `production_packaging_detail` VALUES (13,546406,14002,1000.00,'2020-02-26 08:19:07','2020-02-26 08:19:07',2,NULL),(15,653718,14002,1000.00,'2020-02-26 09:04:30','2020-02-26 09:04:30',1,NULL),(16,158606,14002,64.00,'2020-02-26 09:04:47','2020-02-26 09:04:47',1,NULL),(17,692492,47386,1000.00,'2020-02-27 07:58:26','2020-02-27 07:58:26',2,NULL),(18,612502,47386,728.00,'2020-02-27 07:59:21','2020-02-27 07:59:21',2,NULL),(19,246938,85759,1000.00,'2020-02-28 08:32:57','2020-02-28 08:32:57',3,NULL),(20,413777,85759,1000.00,'2020-02-28 08:33:31','2020-02-28 08:33:31',3,NULL),(21,315714,85759,228.00,'2020-02-28 08:34:05','2020-02-28 08:34:05',3,NULL),(22,394920,74246,90.00,'2020-02-28 08:50:24','2020-02-28 08:50:24',3,NULL),(23,789674,74246,90.00,'2020-02-28 08:50:50','2020-02-28 08:50:50',3,NULL),(24,487543,74246,90.00,'2020-02-28 08:51:11','2020-02-28 08:51:11',3,NULL),(25,284619,74246,90.00,'2020-02-28 08:51:31','2020-02-28 08:51:31',3,NULL),(26,561811,74246,90.00,'2020-02-28 08:51:52','2020-02-28 08:51:52',3,NULL),(27,577486,74246,90.00,'2020-02-28 08:52:11','2020-02-28 08:52:11',3,NULL),(28,909225,41430,1360.00,'2020-03-01 06:07:17','2020-03-01 06:07:17',3,NULL),(29,354592,41430,70.00,'2020-03-01 06:07:53','2020-03-01 06:07:53',3,NULL),(30,822227,74246,90.00,'2020-03-01 07:17:48','2020-03-01 07:17:48',3,NULL),(31,807012,74246,90.00,'2020-03-01 07:18:19','2020-03-01 07:18:19',3,NULL),(32,108926,74246,90.00,'2020-03-01 07:20:17','2020-03-01 07:20:17',3,NULL),(33,172290,74246,90.00,'2020-03-01 07:20:41','2020-03-01 07:20:41',3,NULL),(34,105695,74246,90.00,'2020-03-01 07:20:58','2020-03-01 07:20:58',3,NULL),(35,666675,74246,90.00,'2020-03-01 07:21:15','2020-03-01 07:21:15',3,NULL),(36,316651,74246,90.00,'2020-03-01 07:21:32','2020-03-01 07:21:32',3,NULL),(37,490266,74246,90.00,'2020-03-01 07:21:48','2020-03-01 07:21:48',3,NULL),(38,578755,74246,90.00,'2020-03-01 07:22:02','2020-03-01 07:22:02',3,NULL),(39,167610,74246,90.00,'2020-03-01 07:30:41','2020-03-01 07:30:41',2,NULL),(40,400346,74246,90.00,'2020-03-01 07:31:33','2020-03-01 07:31:33',2,NULL),(41,529779,74246,90.00,'2020-03-01 07:32:17','2020-03-01 07:32:17',2,NULL),(42,628338,74246,90.00,'2020-03-01 07:46:09','2020-03-01 07:46:09',2,NULL),(43,884472,74246,90.00,'2020-03-01 07:47:01','2020-03-01 07:47:01',2,NULL),(44,900807,74246,90.00,'2020-03-01 07:47:36','2020-03-01 07:47:36',2,NULL),(45,163552,74246,58.00,'2020-03-01 07:48:14','2020-03-01 07:48:14',2,NULL),(46,277466,27544,1000.00,'2020-03-01 08:48:53','2020-03-01 08:48:53',2,NULL),(47,834410,27544,900.00,'2020-03-01 08:49:25','2020-03-01 08:49:25',2,NULL),(48,271016,74246,90.00,'2020-03-01 12:10:11','2020-03-01 12:10:11',2,NULL),(49,579304,74246,90.00,'2020-03-01 12:10:59','2020-03-01 12:10:59',2,NULL),(50,393094,66066,1000.00,'2020-03-02 07:59:33','2020-03-02 07:59:33',2,NULL),(51,690412,66066,1000.00,'2020-03-02 08:01:45','2020-03-02 08:01:45',2,NULL),(52,381887,66066,80.00,'2020-03-02 08:02:42','2020-03-02 08:02:42',2,NULL),(53,178330,80675,1000.00,'2020-03-03 07:44:31','2020-03-03 07:44:31',2,NULL),(54,346657,80675,1000.00,'2020-03-03 07:45:11','2020-03-03 07:45:11',2,NULL),(55,726692,80675,88.00,'2020-03-03 07:45:46','2020-03-03 07:45:46',2,NULL),(56,732773,78279,1000.00,'2020-03-03 09:28:48','2020-03-03 09:28:48',2,NULL),(57,955484,78279,1000.00,'2020-03-05 09:47:29','2020-03-05 09:47:29',2,NULL),(58,937836,78279,158.00,'2020-03-05 09:48:10','2020-03-05 09:48:10',2,NULL),(59,923572,51070,1000.00,'2020-03-06 07:19:02','2020-03-06 07:19:02',2,NULL),(60,686403,51070,1000.00,'2020-03-06 07:19:43','2020-03-06 07:19:43',2,NULL),(61,940762,51070,500.00,'2020-03-06 08:27:04','2020-03-06 08:27:04',2,NULL),(67,231476,51070,10.00,'2020-03-07 03:58:25','2020-03-07 03:58:25',1,NULL);
/*!40000 ALTER TABLE `production_packaging_detail` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `production_packagings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `production_packagings` (
  `packing_id` bigint(20) unsigned NOT NULL,
  `qty` decimal(25,2) NOT NULL DEFAULT '0.00',
  `narration` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned DEFAULT NULL,
  `weight` decimal(25,2) DEFAULT '0.00',
  PRIMARY KEY (`packing_id`),
  UNIQUE KEY `production_packagings_packing_id_unique` (`packing_id`),
  KEY `production_packagings_created_by_foreign` (`created_by`),
  KEY `production_packagings_updated_by_foreign` (`updated_by`),
  CONSTRAINT `production_packagings_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `production_packagings_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `production_packagings` WRITE;
/*!40000 ALTER TABLE `production_packagings` DISABLE KEYS */;
INSERT INTO `production_packagings` VALUES (105695,90.00,NULL,'2020-03-01 07:20:58','2020-03-01 07:20:58',3,3,0.00),(108926,90.00,NULL,'2020-03-01 07:20:17','2020-03-01 07:20:17',3,3,0.00),(158606,64.00,NULL,'2020-02-26 09:04:47','2020-02-26 09:04:47',1,1,0.00),(163552,58.00,NULL,'2020-03-01 07:48:14','2020-03-01 07:48:14',2,2,0.00),(167610,90.00,NULL,'2020-03-01 07:30:41','2020-03-01 07:30:41',2,2,0.00),(172290,90.00,NULL,'2020-03-01 07:20:41','2020-03-01 07:20:41',3,3,0.00),(178330,1000.00,NULL,'2020-03-03 07:44:31','2020-03-03 07:44:31',2,2,0.00),(231476,10.00,NULL,'2020-03-07 03:57:31','2020-03-07 03:58:25',1,1,5800.00),(246938,1000.00,NULL,'2020-02-28 08:32:57','2020-02-28 08:32:57',3,3,0.00),(271016,90.00,NULL,'2020-03-01 12:10:11','2020-03-01 12:10:11',2,2,0.00),(277466,1000.00,NULL,'2020-03-01 08:48:53','2020-03-01 08:48:53',2,2,0.00),(284619,90.00,NULL,'2020-02-28 08:51:31','2020-02-28 08:51:31',3,3,0.00),(315714,228.00,NULL,'2020-02-28 08:34:05','2020-02-28 08:34:05',3,3,0.00),(316651,90.00,NULL,'2020-03-01 07:21:32','2020-03-01 07:21:32',3,3,0.00),(346657,1000.00,NULL,'2020-03-03 07:45:11','2020-03-03 07:45:11',2,2,0.00),(354592,70.00,NULL,'2020-03-01 06:07:53','2020-03-01 06:07:53',3,3,0.00),(381887,80.00,NULL,'2020-03-02 08:02:42','2020-03-02 08:02:42',2,2,0.00),(393094,1000.00,NULL,'2020-03-02 07:59:33','2020-03-02 07:59:33',2,2,0.00),(394920,90.00,NULL,'2020-02-28 08:50:24','2020-02-28 08:50:24',3,3,0.00),(400346,90.00,NULL,'2020-03-01 07:31:33','2020-03-01 07:31:33',2,2,0.00),(413777,1000.00,NULL,'2020-02-28 08:33:31','2020-02-28 08:33:31',3,3,0.00),(487543,90.00,NULL,'2020-02-28 08:51:11','2020-02-28 08:51:11',3,3,0.00),(490266,90.00,NULL,'2020-03-01 07:21:47','2020-03-01 07:21:48',3,3,0.00),(529779,90.00,NULL,'2020-03-01 07:32:17','2020-03-01 07:32:17',2,2,0.00),(546406,1000.00,NULL,'2020-02-26 08:19:07','2020-02-26 08:19:07',2,2,0.00),(561811,90.00,NULL,'2020-02-28 08:51:52','2020-02-28 08:51:52',3,3,0.00),(577486,90.00,NULL,'2020-02-28 08:52:11','2020-02-28 08:52:11',3,3,0.00),(578755,90.00,NULL,'2020-03-01 07:22:02','2020-03-01 07:22:03',3,3,0.00),(579304,90.00,NULL,'2020-03-01 12:10:59','2020-03-01 12:10:59',2,2,0.00),(612502,728.00,NULL,'2020-02-27 07:59:21','2020-02-27 07:59:21',2,2,0.00),(628338,90.00,NULL,'2020-03-01 07:46:09','2020-03-01 07:46:09',2,2,0.00),(653718,1000.00,NULL,'2020-02-26 08:48:16','2020-02-26 09:04:30',1,1,0.00),(666675,90.00,NULL,'2020-03-01 07:21:15','2020-03-01 07:21:15',3,3,0.00),(686403,1000.00,NULL,'2020-03-06 07:19:43','2020-03-06 07:19:43',2,2,0.00),(690412,1000.00,NULL,'2020-03-02 08:01:44','2020-03-02 08:01:45',2,2,0.00),(692492,1000.00,NULL,'2020-02-27 07:58:26','2020-02-27 07:58:26',2,2,0.00),(726692,88.00,NULL,'2020-03-03 07:45:46','2020-03-03 07:45:46',2,2,0.00),(732773,1000.00,NULL,'2020-03-03 09:28:48','2020-03-03 09:28:48',2,2,0.00),(789674,90.00,NULL,'2020-02-28 08:50:50','2020-02-28 08:50:50',3,3,0.00),(807012,90.00,NULL,'2020-03-01 07:18:19','2020-03-01 07:18:19',3,3,0.00),(822227,90.00,NULL,'2020-03-01 07:17:48','2020-03-01 07:17:48',3,3,0.00),(834410,900.00,NULL,'2020-03-01 08:49:25','2020-03-01 08:49:25',2,2,0.00),(884472,90.00,NULL,'2020-03-01 07:47:01','2020-03-01 07:47:01',2,2,0.00),(900807,90.00,NULL,'2020-03-01 07:47:36','2020-03-01 07:47:36',2,2,0.00),(909225,1360.00,NULL,'2020-03-01 06:07:17','2020-03-01 06:07:17',3,3,0.00),(923572,1000.00,NULL,'2020-03-06 07:19:02','2020-03-06 07:19:02',2,2,0.00),(937836,158.00,NULL,'2020-03-05 09:48:10','2020-03-05 09:48:10',2,2,0.00),(940762,500.00,NULL,'2020-03-06 08:27:04','2020-03-06 08:27:04',2,2,0.00),(955484,1000.00,NULL,'2020-03-05 09:47:29','2020-03-05 09:47:29',2,2,0.00);
/*!40000 ALTER TABLE `production_packagings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `production_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `production_status` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tag` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `production_status` WRITE;
/*!40000 ALTER TABLE `production_status` DISABLE KEYS */;
INSERT INTO `production_status` VALUES (1,'READY FOR PRODUCTION','READY_FOR_PRODUCTION','2020-02-14 17:52:52',NULL),(2,'STARTED','STARTED','2020-02-14 17:52:52',NULL),(3,'STOPPED','STOPPED','2020-02-14 17:52:52',NULL),(4,'COMPLETED','COMPLETED','2020-02-14 17:52:52',NULL);
/*!40000 ALTER TABLE `production_status` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `production_sum_view`;
/*!50001 DROP VIEW IF EXISTS `production_sum_view`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE VIEW `production_sum_view` AS SELECT 
 1 AS `material_id`,
 1 AS `cycle_time`,
 1 AS `expected_mould`,
 1 AS `bond_product`,
 1 AS `bond_name`,
 1 AS `bond_type_id`,
 1 AS `product_type`,
 1 AS `weight`,
 1 AS `powder_cost`,
 1 AS `piece_per_mould`,
 1 AS `status`,
 1 AS `duration`,
 1 AS `mould`,
 1 AS `remaining_piece`,
 1 AS `electricity_out_duration`,
 1 AS `other_prod_blocker_duration`,
 1 AS `qty`,
 1 AS `rejection_under_size_qty`,
 1 AS `rejection_over_size_qty`,
 1 AS `rejection_shape_qty`,
 1 AS `net_qty`,
 1 AS `unit`*/;
SET character_set_client = @saved_cs_client;
DROP TABLE IF EXISTS `production_view`;
/*!50001 DROP VIEW IF EXISTS `production_view`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE VIEW `production_view` AS SELECT 
 1 AS `material_id`,
 1 AS `cycle_time`,
 1 AS `expected_mould`,
 1 AS `bond_product`,
 1 AS `bond_name`,
 1 AS `bond_type_id`,
 1 AS `product_type`,
 1 AS `weight`,
 1 AS `powder_cost`,
 1 AS `piece_per_mould`,
 1 AS `status`,
 1 AS `duration`,
 1 AS `mould`,
 1 AS `remaining_piece`,
 1 AS `electricity_out_duration`,
 1 AS `other_prod_blocker_duration`,
 1 AS `qty`,
 1 AS `rejection_under_size_qty`,
 1 AS `rejection_over_size_qty`,
 1 AS `rejection_shape_qty`,
 1 AS `net_qty`,
 1 AS `unit`*/;
SET character_set_client = @saved_cs_client;
DROP TABLE IF EXISTS `quality_checks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `quality_checks` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `material_id` bigint(20) unsigned NOT NULL,
  `qty` decimal(25,2) NOT NULL,
  `rejection_under_size_qty` decimal(25,2) DEFAULT '0.00',
  `rejection_over_size_qty` decimal(25,2) DEFAULT '0.00',
  `rejection_shape_qty` decimal(25,2) DEFAULT '0.00',
  `net_qty` decimal(25,2) NOT NULL,
  `rejection_reason` enum('PUNCH_FAULT','DIE_FAULT','PATTI_FAULT','WEIGHT_ACCURACY_FAULT','HUMEN_MISTAKE','OTHER') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reason` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `quality_checks_created_by_foreign` (`created_by`),
  KEY `quality_checks_updated_by_foreign` (`updated_by`),
  KEY `quality_checks_material_id_foreign` (`material_id`),
  CONSTRAINT `quality_checks_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `quality_checks_material_id_foreign` FOREIGN KEY (`material_id`) REFERENCES `bond_material_recipes` (`material_id`),
  CONSTRAINT `quality_checks_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `quality_checks` WRITE;
/*!40000 ALTER TABLE `quality_checks` DISABLE KEYS */;
INSERT INTO `quality_checks` VALUES (10,14002,2064.00,12.00,0.00,0.00,2076.00,NULL,NULL,'2020-02-26 08:11:23','2020-02-26 08:36:16',2,1),(11,47386,1728.00,0.00,0.00,0.00,1728.00,NULL,NULL,'2020-02-27 07:56:07','2020-02-27 07:56:07',2,NULL),(12,85759,2228.00,1.00,3.00,0.00,2232.00,NULL,NULL,'2020-02-28 08:32:21','2020-02-28 08:32:21',3,NULL),(13,74246,540.00,0.00,0.00,0.00,540.00,NULL,NULL,'2020-02-28 08:50:00','2020-02-28 08:50:00',3,NULL),(14,41430,1430.00,5.00,0.00,5.00,1440.00,NULL,NULL,'2020-03-01 06:06:53','2020-03-01 06:06:53',3,NULL),(15,74246,810.00,0.00,0.00,0.00,810.00,NULL,NULL,'2020-03-01 07:17:26','2020-03-01 07:17:26',3,NULL),(16,74246,270.00,0.00,0.00,0.00,270.00,NULL,NULL,'2020-03-01 07:30:00','2020-03-01 07:30:00',2,NULL),(17,74246,329.00,1.00,0.00,0.00,330.00,NULL,NULL,'2020-03-01 07:45:41','2020-03-01 07:45:41',2,NULL),(18,74246,180.00,0.00,0.00,0.00,180.00,NULL,NULL,'2020-03-01 08:16:18','2020-03-01 08:16:18',2,NULL),(19,27544,1903.00,29.00,12.00,0.00,1944.00,NULL,NULL,'2020-03-01 08:48:22','2020-03-01 08:48:22',2,NULL),(20,66066,2080.00,8.00,0.00,0.00,2088.00,NULL,NULL,'2020-03-02 07:58:53','2020-03-02 07:58:53',2,NULL),(21,80675,2088.00,0.00,0.00,0.00,2088.00,NULL,NULL,'2020-03-03 07:44:02','2020-03-03 07:44:02',2,NULL),(22,78279,1000.00,7.00,0.00,0.00,1007.00,NULL,NULL,'2020-03-03 09:28:22','2020-03-03 09:28:22',2,NULL),(23,78279,158.00,2.00,0.00,0.00,160.00,NULL,NULL,'2020-03-05 09:41:10','2020-03-05 09:41:10',2,NULL),(24,78279,993.00,0.00,0.00,0.00,993.00,NULL,NULL,'2020-03-05 09:46:55','2020-03-05 09:46:55',2,NULL),(25,51070,2000.00,12.00,0.00,0.00,2012.00,NULL,NULL,'2020-03-06 07:18:24','2020-03-06 07:18:24',2,NULL),(26,51070,500.00,0.00,0.00,0.00,500.00,NULL,NULL,'2020-03-06 08:26:39','2020-03-06 08:26:39',2,NULL);
/*!40000 ALTER TABLE `quality_checks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `role_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `role_user` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `role_user_role_id_index` (`role_id`),
  KEY `role_user_user_id_index` (`user_id`),
  CONSTRAINT `role_user_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_user_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `role_user` WRITE;
/*!40000 ALTER TABLE `role_user` DISABLE KEYS */;
INSERT INTO `role_user` VALUES (1,1,1,'2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(2,2,1,'2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(3,2,3,'2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(4,2,4,'2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(5,3,2,'2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(6,4,2,'2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(7,4,5,'2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(8,3,5,'2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(9,5,5,'2020-02-23 17:52:52','2020-02-23 17:52:52',NULL);
/*!40000 ALTER TABLE `role_user` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `roles` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `level` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'MasterAdmin','masteradmin','Master Admin Role',10,'2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(2,'Admin','admin','Admin Role',9,'2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(3,'ProductionManager','production','Production Manager Role',8,'2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(4,'Packing & Store Manager','packingstoremanager','Production & Store Manager Role',7,'2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(5,'Sales Manager','salesmanager','Sales Manager Role',6,'2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(6,'Parcel Delivery Manager','parceldeliverymanager','Parcel Delivery Manager Role',5,'2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(7,'Purchase Manager','purchasemanager','Purchase Role',4,'2020-02-14 17:52:52','2020-02-14 17:52:52',NULL),(8,'View Packed Stock','view.reportpackedstock','Can view packed stock',0,'2020-02-23 04:41:05','2020-02-23 04:41:05',NULL);
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `val` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `group` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_view`;
/*!50001 DROP VIEW IF EXISTS `stock_view`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE VIEW `stock_view` AS SELECT 
 1 AS `material_id`,
 1 AS `bond_product`,
 1 AS `bond_name`,
 1 AS `product_type`,
 1 AS `qty`,
 1 AS `rejection_under_size_qty`,
 1 AS `rejection_over_size_qty`,
 1 AS `rejection_shape_qty`,
 1 AS `net_qty`,
 1 AS `unit`*/;
SET character_set_client = @saved_cs_client;
DROP TABLE IF EXISTS `units`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `units` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` enum('DIMENSION','WEIGHT','QTY') COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `units` WRITE;
/*!40000 ALTER TABLE `units` DISABLE KEYS */;
INSERT INTO `units` VALUES (1,'Pieces','pcs','QTY','2020-02-14 17:52:53',NULL),(2,'Kilogram','kg','WEIGHT','2020-02-14 17:52:53',NULL),(3,'Gram','gm','WEIGHT','2020-02-14 17:52:53',NULL),(4,'Litre','ltr','WEIGHT','2020-02-14 17:52:53',NULL),(5,'mm','mm','DIMENSION','2020-02-14 17:52:53',NULL),(6,'feet','ft','DIMENSION','2020-02-14 17:52:53',NULL),(7,'Centimeter','cm','DIMENSION','2020-02-14 17:52:53',NULL),(8,'Inch','inch','DIMENSION','2020-02-14 17:52:53',NULL);
/*!40000 ALTER TABLE `units` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `username` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `preferences` json DEFAULT NULL,
  `password_changed_at` timestamp NULL DEFAULT NULL,
  `dob` date NOT NULL,
  `status` enum('ACTIVE','INACTIVE','LOCKED','BLOCKED') COLLATE utf8mb4_unicode_ci NOT NULL,
  `google2fa_secret` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_username_unique` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'Amar Master Admin','pradeep.p28','pareekpradeep786@gmail.com',NULL,'$2y$10$nTH2B22uW55f0yOsEetON.XIewTLexJ9IFcfrWkzQhUIKR5SnI8.S','+91-9958859998',NULL,NULL,'2020-02-14 19:08:05','1989-11-28','ACTIVE',NULL,'j7Q1zAKR6RsIhk20vADKoH3Jc3mBoN6X7uIOPRYAXguSO8ZCsXR6fduJdwMu','2020-02-14 17:52:52','2020-02-14 19:08:05'),(2,'Prakash Gujar','prakash.g',NULL,NULL,'$2y$10$G2Bs9kWULWt3d1YUMs0s2u547YcHqAImNhE0z1DGaW7nBj9GTgJJ2','+91-9024911432',NULL,NULL,'2020-02-24 09:30:16','1994-11-28','ACTIVE',NULL,NULL,'2020-02-14 17:52:52','2020-02-24 09:30:16'),(3,'Sandeep Pareek','sandeep.p16','s.pareek0874@gmail.com',NULL,'$2y$10$asLJxGPJ2sXNPiAxnOXQWeG4VK0FC4GkmU4RZgBtFh8F0wHib.f2u','+91-9414220874',NULL,NULL,'2020-02-22 05:06:45','1989-07-16','ACTIVE',NULL,NULL,'2020-02-14 17:52:52','2020-02-22 05:06:45'),(4,'Ram Avtaar Pareek','ram.a11','salasarspares07@gmail.com',NULL,'$2y$10$FNPQHjSFwb7MoNZ8HFw8jef4vLJVTKYwV.5A9isDET9EwPLm4fbtq','+91-9413319707',NULL,NULL,'2020-02-24 03:02:39','1965-12-11','ACTIVE',NULL,NULL,'2020-02-14 17:52:52','2020-02-24 03:02:39'),(5,'Mangal Singh Rathore','mangal.s',NULL,NULL,'$2y$10$9BheV5/rkw30THEEWneooelvO/GsGXDX.ssaIH6x/sx/ItRNtkVjq','+91-6376745203',NULL,NULL,NULL,'1965-07-16','ACTIVE',NULL,NULL,'2020-02-14 17:52:52',NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
/*!50001 DROP VIEW IF EXISTS `account_total_view`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50001 VIEW `account_total_view` AS select `av`.`account_id` AS `account_id`,`av`.`group_id` AS `group_id`,`av`.`name` AS `name`,`av`.`account_group` AS `account_group`,`av`.`tr_date` AS `tr_date`,`av`.`month` AS `month`,ifnull(`av`.`cr_total`,0) AS `cr_total`,ifnull(`av`.`dr_total`,0) AS `dr_total` from `account_view` `av` union all select `a`.`id` AS `id`,`ag`.`id` AS `id`,`a`.`name` AS `name`,`ag`.`name` AS `name`,NULL AS `NULL`,NULL AS `NULL`,ifnull(`a`.`balance_cr`,0) AS `IFNULL(a.balance_cr,0)`,ifnull(`a`.`balance_dr`,0) AS `IFNULL(a.balance_dr,0)` from (`accounts` `a` left join `account_groups` `ag` on((`a`.`group_id` = `ag`.`id`))) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;
/*!50001 DROP VIEW IF EXISTS `account_view`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50001 VIEW `account_view` AS select `a`.`name` AS `name`,`a`.`id` AS `account_id`,`ag`.`name` AS `account_group`,`ag`.`id` AS `group_id`,`e`.`tr_date` AS `tr_date`,month(`e`.`tr_date`) AS `month`,`et`.`name` AS `entrytype`,`e`.`invoice_ref_id` AS `invoice_ref_id`,ifnull(`ei`.`cr_total`,0) AS `cr_total`,ifnull(`ei`.`dr_total`,0) AS `dr_total`,`e`.`narration` AS `narration`,`ei`.`entry_id` AS `entry_id`,(year(`e`.`tr_date`) + month(`e`.`tr_date`)) AS `yearmonthindex`,ifnull(`a`.`balance_cr`,0) AS `op_balance_cr`,ifnull(`a`.`balance_dr`,0) AS `op_balance_dr` from ((((`entryitems` `ei` left join `accounts` `a` on((`ei`.`account_id` = `a`.`id`))) left join `entries` `e` on((`ei`.`entry_id` = `e`.`id`))) left join `account_groups` `ag` on((`a`.`group_id` = `ag`.`id`))) left join `entry_types` `et` on((`e`.`entrytype_id` = `et`.`id`))) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;
/*!50001 DROP VIEW IF EXISTS `consumable_stock_view`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50001 VIEW `consumable_stock_view` AS select `ci`.`id` AS `id`,json_unquote(json_extract(`ci`.`name`,'$.en')) AS `consumable_name`,`ci`.`spec` AS `spec`,`ci`.`add_spec` AS `add_spec`,`ci`.`weight` AS `weight`,`ci`.`opening_stock` AS `qty`,`ci`.`unit_price` AS `unit_price`,(`ci`.`opening_stock` * `ci`.`unit_price`) AS `stock_value`,json_unquote(json_extract(`cc`.`name`,'$.en')) AS `category`,`u`.`alias` AS `alias`,`ci`.`category_id` AS `category_id`,`ci`.`created_at` AS `created_at`,0 AS `consumed_percentage`,0 AS `consumed_qty`,'consumable_itme' AS `type` from ((`amartoolsdb`.`consumable_items` `ci` left join `amartoolsdb`.`units` `u` on((`ci`.`opening_stock_unit` = `u`.`id`))) left join `amartoolsdb`.`consumable_categories` `cc` on((`ci`.`category_id` = `cc`.`id`))) union all select `icd`.`consumable_id` AS `consumable_id`,json_unquote(json_extract(`ci`.`name`,'$.en')) AS `ci.name->>'$.en'`,`ci`.`spec` AS `spec`,`ci`.`add_spec` AS `add_spec`,`ci`.`weight` AS `weight`,`icd`.`qty` AS `qty`,`icd`.`unit_price` AS `unit_price`,(`icd`.`qty` * `icd`.`unit_price`) AS `stock_value`,json_unquote(json_extract(`cc`.`name`,'$.en')) AS `cc.name->>'$.en'`,`u`.`alias` AS `alias`,`ci`.`category_id` AS `category_id`,`icd`.`created_at` AS `created_at`,0 AS `consumed_percentage`,0 AS `consumed_qty`,'invoice_consumable' AS `type` from (((`amartoolsdb`.`invoice_consumable_detail` `icd` left join `amartoolsdb`.`consumable_items` `ci` on((`icd`.`consumable_id` = `ci`.`id`))) left join `amartoolsdb`.`units` `u` on((`ci`.`opening_stock_unit` = `u`.`id`))) left join `amartoolsdb`.`consumable_categories` `cc` on((`ci`.`category_id` = `cc`.`id`))) union all (select `ccd`.`consumable_id` AS `consumable_id`,json_unquote(json_extract(`ci`.`name`,'$.en')) AS `ci.name->>'$.en'`,`ci`.`spec` AS `spec`,`ci`.`add_spec` AS `add_spec`,`ci`.`weight` AS `weight`,-(`ccd`.`qty`) AS `qty`,`ccd`.`unit_price` AS `unit_price`,(`ccd`.`qty` * `ccd`.`unit_price`) AS `stock_value`,json_unquote(json_extract(`cc`.`name`,'$.en')) AS `cc.name->>'$.en'`,`u`.`alias` AS `alias`,`ci`.`category_id` AS `category_id`,`ccd`.`created_at` AS `created_at`,`ccd`.`consumed_percentage` AS `consumed_percentage`,((`ccd`.`qty` * `ccd`.`consumed_percentage`) / 100) AS `consumed_qty`,'consumpation' AS `type` from ((((`amartoolsdb`.`consumpation_price_view` `ccd` left join `amartoolsdb`.`consumable_items` `ci` on((`ccd`.`consumable_id` = `ci`.`id`))) left join `amartoolsdb`.`units` `u` on((`ci`.`opening_stock_unit` = `u`.`id`))) left join `amartoolsdb`.`consumable_categories` `cc` on((`ci`.`category_id` = `cc`.`id`))) left join `amartoolsdb`.`consumable_consumpations` `ccn` on((`ccd`.`consumpation_id` = `ccn`.`id`)))) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;
/*!50001 DROP VIEW IF EXISTS `consumpation_price_view`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50001 VIEW `consumpation_price_view` AS select `ccd`.`id` AS `id`,`ccd`.`consumpation_id` AS `consumpation_id`,`ccd`.`consumable_id` AS `consumable_id`,`ccd`.`qty` AS `qty`,`ccd`.`consumed_percentage` AS `consumed_percentage`,`ccd`.`created_at` AS `created_at`,`ccd`.`updated_at` AS `updated_at`,`ccd`.`created_by` AS `created_by`,`ccd`.`updated_by` AS `updated_by`,(case when isnull(`icd`.`unit_price`) then `ci`.`unit_price` else `icd`.`unit_price` end) AS `unit_price` from ((`amartoolsdb`.`consumable_consumpation_details` `ccd` left join (select `amartoolsdb`.`invoice_consumable_detail`.`consumable_id` AS `consumable_id`,`amartoolsdb`.`invoice_consumable_detail`.`unit_price` AS `unit_price` from `amartoolsdb`.`invoice_consumable_detail` order by `amartoolsdb`.`invoice_consumable_detail`.`id` desc) `icd` on((`icd`.`consumable_id` = `ccd`.`consumable_id`))) left join `amartoolsdb`.`consumable_items` `ci` on((`ci`.`id` = `ccd`.`consumable_id`))) group by `ccd`.`consumable_id` */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;
/*!50001 DROP VIEW IF EXISTS `packed_stock_view`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50001 VIEW `packed_stock_view` AS select `ppd`.`material_id` AS `material_id`,`ppd`.`packing_id` AS `packing_id`,`bp`.`name` AS `bond_product`,`b`.`name` AS `bond_name`,`bpt`.`name` AS `product_type`,`ppd`.`qty` AS `qty`,`u`.`alias` AS `unit` from (((((((`production_packagings` `pp` left join `production_packaging_detail` `ppd` on((`pp`.`packing_id` = `ppd`.`packing_id`))) left join `bond_material_recipes` `bmr` on((`ppd`.`material_id` = `bmr`.`material_id`))) left join `bond_products` `bp` on((`bmr`.`bond_product_id` = `bp`.`id`))) left join `units` `u` on((`u`.`id` = `bp`.`qty_unit_id`))) left join `bond_product_types` `bpt` on((`bp`.`bond_type_id` = `bpt`.`id`))) left join `bonds` `b` on((`bp`.`bond_id` = `b`.`id`))) left join `bond_process_params` `bpp` on((`bmr`.`bond_process_id` = `bpp`.`id`))) union all select `ppd`.`material_id` AS `material_id`,`ppd`.`packing_id` AS `packing_id`,`bp`.`name` AS `bond_product`,`b`.`name` AS `bond`,`bpt`.`name` AS `product_type`,-(`ppd`.`qty`) AS `-(ppd.qty)`,`u`.`alias` AS `unit` from ((((((((`bond_invoice_detail` `bid` left join `production_packagings` `pp` on((`bid`.`packing_id` = `pp`.`packing_id`))) left join `production_packaging_detail` `ppd` on((`pp`.`packing_id` = `ppd`.`packing_id`))) left join `bond_material_recipes` `bmr` on((`ppd`.`material_id` = `bmr`.`material_id`))) left join `bond_products` `bp` on((`bmr`.`bond_product_id` = `bp`.`id`))) left join `units` `u` on((`u`.`id` = `bp`.`qty_unit_id`))) left join `bond_product_types` `bpt` on((`bp`.`bond_type_id` = `bpt`.`id`))) left join `bonds` `b` on((`bp`.`bond_id` = `b`.`id`))) left join `bond_process_params` `bpp` on((`bmr`.`bond_process_id` = `bpp`.`id`))) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;
/*!50001 DROP VIEW IF EXISTS `production_sum_view`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50001 VIEW `production_sum_view` AS select `pv`.`material_id` AS `material_id`,max(`pv`.`cycle_time`) AS `cycle_time`,max(`pv`.`expected_mould`) AS `expected_mould`,`pv`.`bond_product` AS `bond_product`,`pv`.`bond_name` AS `bond_name`,`pv`.`bond_type_id` AS `bond_type_id`,`pv`.`product_type` AS `product_type`,sum(`pv`.`weight`) AS `weight`,`pv`.`powder_cost` AS `powder_cost`,`pv`.`piece_per_mould` AS `piece_per_mould`,`pv`.`status` AS `status`,sum(`pv`.`duration`) AS `duration`,sum(`pv`.`mould`) AS `mould`,sum(`pv`.`remaining_piece`) AS `remaining_piece`,sum(`pv`.`electricity_out_duration`) AS `electricity_out_duration`,sum(`pv`.`other_prod_blocker_duration`) AS `other_prod_blocker_duration`,sum(`pv`.`qty`) AS `qty`,sum(`pv`.`rejection_under_size_qty`) AS `rejection_under_size_qty`,sum(`pv`.`rejection_over_size_qty`) AS `rejection_over_size_qty`,sum(`pv`.`rejection_shape_qty`) AS `rejection_shape_qty`,sum(`pv`.`net_qty`) AS `net_qty`,`pv`.`unit` AS `unit` from `production_view` `pv` group by `pv`.`material_id` */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;
/*!50001 DROP VIEW IF EXISTS `production_view`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50001 VIEW `production_view` AS select `bmr`.`material_id` AS `material_id`,`bpp`.`cycle_time` AS `cycle_time`,`bpp`.`expected_mould` AS `expected_mould`,`bp`.`name` AS `bond_product`,`b`.`name` AS `bond_name`,`bp`.`bond_type_id` AS `bond_type_id`,`bpt`.`name` AS `product_type`,`bmr`.`weight` AS `weight`,`bmr`.`powder_cost` AS `powder_cost`,(select `cs`.`qty` from (`bond_process_consumable` `bpc` join `consumable_settings` `cs` on((`bpc`.`consumable_settings_id` = `cs`.`id`))) where ((`bpc`.`bond_process_id` = `bmr`.`bond_process_id`) and (`cs`.`type` = 'MOULD'))) AS `piece_per_mould`,(select `ps`.`tag` AS `status` from (`bond_recipe_production_status` `brps` left join `production_status` `ps` on((`brps`.`status_id` = `ps`.`id`))) where (`brps`.`material_id` = `bmr`.`material_id`) order by `brps`.`created_at` desc limit 1) AS `status`,0 AS `duration`,0 AS `mould`,0 AS `remaining_piece`,0 AS `electricity_out_duration`,0 AS `other_prod_blocker_duration`,0 AS `qty`,0 AS `rejection_under_size_qty`,0 AS `rejection_over_size_qty`,0 AS `rejection_shape_qty`,0 AS `net_qty`,`u`.`alias` AS `unit` from (((((`bond_material_recipes` `bmr` left join `bond_products` `bp` on((`bmr`.`bond_product_id` = `bp`.`id`))) left join `bond_product_types` `bpt` on((`bp`.`bond_type_id` = `bpt`.`id`))) left join `units` `u` on((`u`.`id` = `bp`.`qty_unit_id`))) left join `bonds` `b` on((`bp`.`bond_id` = `b`.`id`))) left join `bond_process_params` `bpp` on((`bmr`.`bond_process_id` = `bpp`.`id`))) union all select `brp`.`material_id` AS `material_id`,0 AS `0`,0 AS `0`,`bp`.`name` AS `name`,`b`.`name` AS `name`,`bp`.`bond_type_id` AS `bond_type_id`,`bpt`.`name` AS `name`,0 AS `0`,0 AS `0`,0 AS `0`,NULL AS `NULL`,sum(`brp`.`duration`) AS `duration`,sum(`brp`.`mould`) AS `mould`,ifnull(sum(`brp`.`remaining_piece`),0) AS `remaining_piece`,sum(`brp`.`electricity_out_duration`) AS `electricity_out_duration`,sum(`brp`.`other_prod_blocker_duration`) AS `other_prod_blocker_duration`,0 AS `qty`,0 AS `rejection_under_size_qty`,0 AS `rejection_over_size_qty`,0 AS `rejection_shape_qty`,0 AS `net_qty`,`u`.`alias` AS `unit` from ((((((`bond_recipe_productions` `brp` left join `bond_material_recipes` `bmr` on((`brp`.`material_id` = `bmr`.`material_id`))) left join `bond_products` `bp` on((`bmr`.`bond_product_id` = `bp`.`id`))) left join `units` `u` on((`u`.`id` = `bp`.`qty_unit_id`))) left join `bond_product_types` `bpt` on((`bp`.`bond_type_id` = `bpt`.`id`))) left join `bonds` `b` on((`bp`.`bond_id` = `b`.`id`))) left join `bond_process_params` `bpp` on((`bmr`.`bond_process_id` = `bpp`.`id`))) group by `brp`.`material_id` union all select `qc`.`material_id` AS `material_id`,0 AS `0`,0 AS `0`,`bp`.`name` AS `name`,`b`.`name` AS `name`,`bp`.`bond_type_id` AS `bond_type_id`,`bpt`.`name` AS `name`,0 AS `0`,0 AS `0`,0 AS `0`,NULL AS `NULL`,0 AS `0`,0 AS `0`,0 AS `0`,0 AS `0`,0 AS `0`,sum(`qc`.`qty`) AS `qty`,sum(`qc`.`rejection_under_size_qty`) AS `rejection_under_size_qty`,sum(`qc`.`rejection_over_size_qty`) AS `rejection_over_size_qty`,sum(`qc`.`rejection_shape_qty`) AS `rejection_shape_qty`,sum(`qc`.`net_qty`) AS `net_qty`,`u`.`alias` AS `unit` from ((((((`quality_checks` `qc` left join `bond_material_recipes` `bmr` on((`bmr`.`material_id` = `qc`.`material_id`))) left join `bond_products` `bp` on((`bmr`.`bond_product_id` = `bp`.`id`))) left join `units` `u` on((`u`.`id` = `bp`.`qty_unit_id`))) left join `bond_product_types` `bpt` on((`bp`.`bond_type_id` = `bpt`.`id`))) left join `bonds` `b` on((`bp`.`bond_id` = `b`.`id`))) left join `bond_process_params` `bpp` on((`bmr`.`bond_process_id` = `bpp`.`id`))) group by `qc`.`material_id` */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;
/*!50001 DROP VIEW IF EXISTS `stock_view`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50001 VIEW `stock_view` AS select `psv`.`material_id` AS `material_id`,`psv`.`bond_product` AS `bond_product`,`psv`.`bond_name` AS `bond_name`,`psv`.`product_type` AS `product_type`,`psv`.`qty` AS `qty`,`psv`.`rejection_under_size_qty` AS `rejection_under_size_qty`,`psv`.`rejection_over_size_qty` AS `rejection_over_size_qty`,`psv`.`rejection_shape_qty` AS `rejection_shape_qty`,`psv`.`net_qty` AS `net_qty`,`psv`.`unit` AS `unit` from `production_sum_view` `psv` union all select `ppd`.`material_id` AS `material_id`,`bp`.`name` AS `bond_product`,`b`.`name` AS `bond`,`bpt`.`name` AS `product_type`,-(`ppd`.`qty`) AS `-(ppd.qty)`,0 AS `0`,0 AS `0`,0 AS `0`,0 AS `0`,`u`.`alias` AS `unit` from ((((((((`bond_invoice_detail` `bid` left join `production_packagings` `pp` on((`bid`.`packing_id` = `pp`.`packing_id`))) left join `production_packaging_detail` `ppd` on((`pp`.`packing_id` = `ppd`.`packing_id`))) left join `bond_material_recipes` `bmr` on((`ppd`.`material_id` = `bmr`.`material_id`))) left join `bond_products` `bp` on((`bmr`.`bond_product_id` = `bp`.`id`))) left join `units` `u` on((`u`.`id` = `bp`.`qty_unit_id`))) left join `bond_product_types` `bpt` on((`bp`.`bond_type_id` = `bpt`.`id`))) left join `bonds` `b` on((`bp`.`bond_id` = `b`.`id`))) left join `bond_process_params` `bpp` on((`bmr`.`bond_process_id` = `bpp`.`id`))) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

