<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

//Route::get('pdf/genInTemp/{invoiceId}', 'Reports\InvoiceReportController@generatePdf');

Route::group(['prefix' => 'v1' , 'middleware' => ['api','auth:api']], function(){  
    Route::get('user', 'UserAPIController@getUserDetail');

    Route::get('template/{type}/{data?}', 'Reports\BaseReportController@getPrinterTemplate');

    // Route::post('accounts/create', 'AccountAPIController@store')->middleware('permission:create.accounts');
    // Route::post('accounts/update/{id}', 'AccountAPIController@update')->middleware('permission:update.accounts');
    // Route::get('accounts/delete/{id}', 'AccountAPIController@destroy')->middleware('permission:delete.accounts');
    // Route::get('accounts/view/{id}', 'AccountAPIController@show')->middleware('permission:view.accounts');
    // Route::get('accounts/list/{type}', 'AccountAPIController@list')->middleware('permission:view.accounts');

    Route::get('app/version', 'OtherAPIController@checkAppVersion');

    Route::get('material/updatestatus', 'MaterialAPIController@updateStatus')->middleware('permission:update.bondrecipeproductions');

    Route::post('material/create', '\App\Http\Controllers\BondMaterialRecipeController@store')->middleware('permission:create.bondmaterialrecipes');
    Route::post('material/update/{id}', '\App\Http\Controllers\BondMaterialRecipeController@update')->middleware('permission:update.bondmaterialrecipes');
    Route::get('material/delete/{id}', '\App\Http\Controllers\BondMaterialRecipeController@destroy')->middleware('permission:delete.bondmaterialrecipes');
    Route::get('material/view/{id}', '\App\Http\Controllers\BondMaterialRecipeController@show')->middleware('permission:view.bondmaterialrecipes');
    Route::get('material/available', 'MaterialAPIController@getListOfReadyforProductionMaterial')->middleware('permission:view.bondmaterialrecipes');
    Route::get('material/list/status/{status}', 'MaterialAPIController@getListOfMaterialWithStatus')->middleware('permission:list.bondmaterialrecipes');
    Route::get('material/list', 'MaterialAPIController@listMaterial');
    Route::post('material/status/update', 'MaterialAPIController@updateStatus');
    Route::get('material/full/{materialId}', 'MaterialAPIController@getMaterialFullDetail');


    Route::post('production/create', '\App\Http\Controllers\BondRecipeProductionController@store')->middleware('permission:create.bondrecipeproductions');
    Route::post('production/update/{id}', '\App\Http\Controllers\BondRecipeProductionController@update')->middleware('permission:update.bondrecipeproductions');
    Route::get('production/delete/{id}', '\App\Http\Controllers\BondRecipeProductionController@destroy')->middleware('permission:delete.bondrecipeproductions');
    Route::get('production/view/{id}', '\App\Http\Controllers\BondRecipeProductionController@show')->middleware('permission:view.bondrecipeproductions');
    Route::get('production/list', 'ProductionAPIController@listProduction');


    Route::post('qualitycheck/create', '\App\Http\Controllers\QualityCheckController@store')->middleware('permission:create.qualitychecks');
    Route::post('qualitycheck/update/{id}', '\App\Http\Controllers\QualityCheckController@update')->middleware('permission:update.qualitychecks');
    Route::get('qualitycheck/delete/{id}', '\App\Http\Controllers\QualityCheckController@destroy')->middleware('permission:delete.qualitychecks');
    Route::get('qualitycheck/view/{id}', '\App\Http\Controllers\QualityCheckController@show')->middleware('permission:view.qualitychecks');
    Route::get('qualitycheck/list', 'QualityCheckAPIController@listQualityCheck');


    //Route::get('productionPackagings/attachPacking/{id}', '\App\Http\Controllers\ProductionPackagingController@attachPacking');
    // Route::post('productionPackagings/attachPacking/{id}', '\App\Http\Controllers\ProductionPackagingController@savePacking');
    // Route::get('productionPackagings/getPacking/{id}', '\App\Http\Controllers\ProductionPackagingController@getPacking');
    // Route::post('productionPackagings/updatePacking/{id}', '\App\Http\Controllers\ProductionPackagingController@updatePacking');
    // Route::post('productionPackagings/deletePacking/{id}', '\App\Http\Controllers\ProductionPackagingController@deletePacking');
    // Route::post('productionPackagings/create', '\App\Http\Controllers\ProductionPackagingController@store');
    // Route::post('productionPackagings/update/{id}', '\App\Http\Controllers\ProductionPackagingController@update');
    // Route::get('productionPackagings/delete/{id}', '\App\Http\Controllers\ProductionPackagingController@destroy');
    // Route::get('productionPackagings/view/{id}', '\App\Http\Controllers\ProductionPackagingController@show');
    Route::post('productionPackagings/create', 'PackagingAPIController@createPackaging')->middleware('permission:create.productionpackagings');
    Route::post('productionPackagings/update/{id}', 'PackagingAPIController@updatePackaging')->middleware('permission:update.productionpackagings');
    Route::get('productionPackagings/delete/{id}', 'PackagingAPIController@deletePackaging')->middleware('permission:delete.productionpackagings');
    Route::get('productionPackagings/view/{id}', 'PackagingAPIController@viewPackaging')->middleware('permission:view.productionpackagings');
    Route::get('productionPackagings/soldview/{id}', 'PackagingAPIController@viewPackagingSold')->middleware('permission:view.productionpackagings');
    Route::get('productionPackagings/list', 'PackagingAPIController@listPackaging');

    Route::post('consumableConsumpations/create', 'ConsumableConsumptionAPIController@createConsumption')->middleware('permission:create.consumableconsumpations');
    Route::post('consumableConsumpations/update/{id}', 'ConsumableConsumptionAPIController@updateConsumption')->middleware('permission:update.consumableconsumpations');
    Route::get('consumableConsumpations/delete/{id}', 'ConsumableConsumptionAPIController@deleteConsumption')->middleware('permission:delete.consumableconsumpations');
    Route::get('consumableConsumpations/view/{id}', 'ConsumableConsumptionAPIController@viewConsumption')->middleware('permission:view.consumableconsumpations');
    Route::get('consumableConsumpations/list', 'ConsumableConsumptionAPIController@listConsumption');

    

    Route::post('accounts/create', '\App\Http\Controllers\AccountController@store')->middleware('permission:create.accounts');
    Route::post('accounts/update/{id}', '\App\Http\Controllers\AccountController@update')->middleware('permission:update.accounts');
    Route::get('accounts/delete/{id}', '\App\Http\Controllers\AccountController@destroy')->middleware('permission:delete.accounts');
    Route::get('accounts/view/{id}', '\App\Http\Controllers\AccountController@view')->middleware('permission:view.accounts');
    Route::get('accounts/list', 'AccountAPIController@searchAccount');     

    Route::post('pendinginvoice/create', '\App\Http\Controllers\API\Invoices\PendingInvoiceController@createPendingInvoice')->middleware('permission:create.invoices');
    Route::post('pendinginvoice/update/{invoiceId}', '\App\Http\Controllers\API\Invoices\PendingInvoiceController@updatePendingInvoice')->middleware('permission:update.invoices');
    Route::post('pendinginvoice/final/{invoiceId}', '\App\Http\Controllers\API\Invoices\PendingInvoiceController@finializePendingInvoice')->middleware('permission:update.invoices');
    Route::get('invoice/delete/{invoiceId}', '\App\Http\Controllers\API\Invoices\BaseInvoiceController@deleteInvoice')->middleware('permission:delete.invoices');
    Route::get('invoice/view/{invoiceId}', '\App\Http\Controllers\API\Invoices\BaseInvoiceController@viewInvoice')->middleware('permission:view.invoices');

    Route::get('invoice/list', '\App\Http\Controllers\API\Invoices\BaseInvoiceController@listInvoice');
    Route::post('consumableinvoice/create', '\App\Http\Controllers\API\Invoices\ConsumableInvoiceController@createInvoice')->middleware('permission:create.invoices');
    Route::post('consumableinvoice/update/{invoiceId}', '\App\Http\Controllers\API\Invoices\ConsumableInvoiceController@updateInvoice')->middleware('permission:update.invoices');
    
    Route::post('productinvoice/create', '\App\Http\Controllers\API\Invoices\ProductInvoiceController@createInvoice')->middleware('permission:create.invoices');
    Route::post('productinvoice/update/{invoiceId}', '\App\Http\Controllers\API\Invoices\ProductInvoiceController@updateInvoice')->middleware('permission:update.invoices');

    Route::post('transaction/create', '\App\Http\Controllers\API\Transaction\TransactionController@createTransaction')->middleware('permission:create.entries');
    Route::post('transaction/update/{entryId}', '\App\Http\Controllers\API\Transaction\TransactionController@updateTransaction')->middleware('permission:create.entries');
    Route::get('transaction/delete/{entryId}', '\App\Http\Controllers\API\Transaction\TransactionController@deleteTransaction')->middleware('permission:delete.entries');
    Route::get('transaction/view/{entryId}', '\App\Http\Controllers\API\Transaction\TransactionController@viewTransaction')->middleware('permission:view.entries');
    Route::get('transaction/list/{type?}', '\App\Http\Controllers\API\Transaction\TransactionController@listTransaction');
    

    Route::get('statement/group', 'AccountStatementAPIController@getGroups')->middleware('permission:view.reportaccountstatement');
    Route::get('statement/accountList/{groupId}', 'AccountStatementAPIController@accountList')->middleware('permission:view.reportaccountstatement');
    Route::get('statement/monthList/{accountId}', 'AccountStatementAPIController@monthList')->middleware('permission:view.reportaccountstatement');
    Route::get('statement/transaction/{accountId}/{month}', 'AccountStatementAPIController@transaction')->middleware('permission:view.reportaccountstatement');

    Route::get('stock/packed', 'BondProductStockAPIController@packedStock')->middleware('permission:view.reportpackedstock');
    Route::get('stock/raw', 'BondProductStockAPIController@rawStock')->middleware('permission:view.reportrawstock');
    Route::get('consumablestock/raw', 'ConsumableStockAPIController@stock')->middleware('permission:view.reportconsumablestock');

    Route::get('data/fresh/{type}/{query?}','\App\Http\Controllers\AdminApi\AdminApiController@freshData');


    Route::get('pdf/genIn/{invoiceId}', 'Reports\InvoiceReportController@generatePdf');

    Route::middleware('cache.headers:private;max_age=3600')->group(function() {
        Route::get('mini/bondprocess', 'MiniAPIController@getBondProcessNames');
        Route::get('mini/bondProduct', 'MiniAPIController@getBondProducts');
        Route::get('data/{type}/{query?}','\App\Http\Controllers\AdminApi\AdminApiController@getAllUserRole');
        Route::get('common/getenum', 'CommonAPIController@getEnums');
    });

    
});


