<?php

namespace App\Http\Controllers;

use App\DataTables\BondProductDataTable;
use App\Http\Requests;
use App\Http\Requests\CreateBondProductRequest;
use App\Http\Requests\UpdateBondProductRequest;
use App\Repositories\BondProductRepository;
use Flash;
use App\Http\Controllers\AppBaseController;
use Response;

class BondProductController extends AppBaseController
{
    /** @var  BondProductRepository */
    private $bondProductRepository;

    public function __construct(BondProductRepository $bondProductRepo)
    {
        $this->bondProductRepository = $bondProductRepo;
    }

    /**
     * Display a listing of the BondProduct.
     *
     * @param BondProductDataTable $bondProductDataTable
     * @return Response
     */
    public function index(BondProductDataTable $bondProductDataTable)
    {
        return $bondProductDataTable->render('bond_products.index');
    }

    /**
     * Show the form for creating a new BondProduct.
     *
     * @return Response
     */
    public function create()
    {
        return view('bond_products.create');
    }


    private function filter($input){
        $input['qty_unit_id'] = $input['unit'];
        $input['bond_id'] = $input['bond'];
        $input['bond_design_id'] = $input['bond_design'];
        $input['bond_type_id'] = $input['bond_type'];
        return $input;
    }
    /**
     * Store a newly created BondProduct in storage.
     *
     * @param CreateBondProductRequest $request
     *
     * @return Response
     */
    public function store(CreateBondProductRequest $request)
    {
        $input = $request->all();
        $input = $this->filter($input);

        $bondProduct = $this->bondProductRepository->create($input);

        Flash::success('Bond Product saved successfully.');

        return redirect(route('bondProducts.index'));
    }

    /**
     * Display the specified BondProduct.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show($id)
    {
        $bondProduct = $this->bondProductRepository->find($id);

        if (empty($bondProduct)) {
            Flash::error('Bond Product not found');

            return redirect(route('bondProducts.index'));
        }

        return view('bond_products.show')->with('bondProduct', $bondProduct);
    }

    /**
     * Show the form for editing the specified BondProduct.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        $bondProduct = $this->bondProductRepository->find($id);

        if (empty($bondProduct)) {
            Flash::error('Bond Product not found');

            return redirect(route('bondProducts.index'));
        }

        return view('bond_products.edit')->with('bondProduct', $bondProduct);
    }

    /**
     * Update the specified BondProduct in storage.
     *
     * @param  int              $id
     * @param UpdateBondProductRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateBondProductRequest $request)
    {
        $input = $request->all();
        $input = $this->filter($input);
        $bondProduct = $this->bondProductRepository->find($id);

        if (empty($bondProduct)) {
            Flash::error('Bond Product not found');

            return redirect(route('bondProducts.index'));
        }

        $bondProduct = $this->bondProductRepository->update($input, $id);

        Flash::success('Bond Product updated successfully.');

        return redirect(route('bondProducts.index'));
    }

    /**
     * Remove the specified BondProduct from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($id)
    {
        $bondProduct = $this->bondProductRepository->find($id);

        if (empty($bondProduct)) {
            Flash::error('Bond Product not found');

            return redirect(route('bondProducts.index'));
        }

        $this->bondProductRepository->delete($id);

        Flash::success('Bond Product deleted successfully.');

        return redirect(route('bondProducts.index'));
    }
}
