<?php

namespace App\Repositories;

use App\Models\Bond;
use App\Repositories\BaseRepository;

/**
 * Class BondRepository
 * @package App\Repositories
 * @version October 11, 2019, 7:53 pm UTC
*/

class BondRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'bond_name',
        'phone',
        'username',
        'email',
        'status'
    ];

    /**
     * Return searchable fields
     *
     * @return array
     */
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }

    /**
     * Configure the Model
     **/
    public function model()
    {
        return Bond::class;
    }
}
