<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBondRecipeProductionsTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bond_recipe_productions', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('material_id');
            $table->dateTime('start_time'); 
            $table->dateTime('end_time'); 
            $table->unsignedBigInteger('duration');
            $table->decimal('mould', 25, 2);
            $table->decimal('remaining_piece', 25, 2)->nullable(true)->default(0);
        
            
            $table->bigInteger('electricity_out_duration')->nullable(true)->default(0);
            $table->bigInteger('other_prod_blocker_duration')->nullable(true)->default(0);

            $priority = CreateUsersTable::f(config('app_data.blocker_reason_enum'));

            $table->enum('other_blocker_reason', $priority)->nullable(true);
            $table->string('reason')->nullable(true);  
            //$table->unsignedBigInteger('qty_unit_id');
           //$table->text('narration')->nullable(true);                     
           

            $table->unsignedBigInteger('created_by')->nullable(false);
            $table->unsignedBigInteger('updated_by')->nullable();
            //$table->unsignedBigInteger('deleted_by')->nullable();

            $table->timestamps();
            //$table->softDeletes();

            $table->foreign('material_id')->references('material_id')->on('bond_material_recipes')->onDelete('cascade');;
            //$table->foreign('qty_unit_id')->references('id')->on('units'); 
            $table->foreign('created_by')->references('id')->on('users');
            $table->foreign('updated_by')->references('id')->on('users');        
            //$table->foreign('deleted_by')->references('id')->on('users');      
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('bond_recipe_productions');
    }
}
