<?php

use Illuminate\Database\Seeder;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class EntryTypesSeeder extends Seeder
{
    private $tableName;

    public function __construct()
    {
        $this->tableName = 'entry_types';
    }

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('entry_tags')->insert([
            'title' => 'normal entry',
            'background_color' => '#f0f0f0',
            'color' => '#000',
            'created_at' => date('Y-m-d H:i:s')       
        ]);
        DB::table($this->tableName)->insert(
            [
                'id' => 1,                                
                'label' => 'receipt',
                'name' => 'Receipt',
                'tag_id' => 1,
                'description' => 'Received in Bank account or Cash account',
                'base_type' => 1,
                'numbering' => 1,
                'suffix' => '',
                'prefix' => '',
                'zero_padding' => 0,
                'restriction_bankcash' => 2,
                'created_at' => date('Y-m-d H:i:s')                                  
            ]
        );

        DB::table($this->tableName)->insert(
            [
                'id' => 2,                                
                'label' => 'payment',
                'name' => 'Payment',
                'tag_id' => 1,
                'description' => 'Payment made from Bank account or Cash account',
                'base_type' => 1,
                'numbering' => 1,
                'suffix' => '',
                'prefix' => '',
                'zero_padding' => 0,
                'restriction_bankcash' => 3,
                'created_at' => date('Y-m-d H:i:s')                                  
            ]
        );
        
        DB::table($this->tableName)->insert(
            [
                'id' => 3,                                
                'label' => 'contra',
                'name' => 'Contra',
                'tag_id' => 1,
                'description' => 'Payment made from Bank account or Cash account',
                'base_type' => 1,
                'numbering' => 1,
                'suffix' => '',
                'prefix' => '',
                'zero_padding' => 0,
                'restriction_bankcash' => 4,
                'created_at' => date('Y-m-d H:i:s')                                  
            ]
        );

        DB::table($this->tableName)->insert(
            [
                'id' => 4,                                
                'label' => 'journal',
                'name' => 'Journal',
                'tag_id' => 1,
                'description' => 'Transfer between Non Bank account and Cash account',
                'base_type' => 1,
                'numbering' => 1,
                'suffix' => '',
                'prefix' => '',
                'zero_padding' => 0,
                'restriction_bankcash' => 5,
                'created_at' => date('Y-m-d H:i:s')                                  
            ]
        );

        DB::table($this->tableName)->insert(
            [
                'id' => 5,                                
                'label' => 'purchase',
                'name' => 'Purchase',
                'tag_id' => 1,
                'description' => 'Purchase',
                'base_type' => 1,
                'numbering' => 1,
                'suffix' => '',
                'prefix' => '',
                'zero_padding' => 0,
                'restriction_bankcash' => 5,
                'created_at' => date('Y-m-d H:i:s')                                  
            ]
        );

        DB::table($this->tableName)->insert(
            [
                'id' => 6,                                
                'label' => 'sales',
                'name' => 'Sale',
                'tag_id' => 1,
                'description' => 'Sale',
                'base_type' => 1,
                'numbering' => 1,
                'suffix' => '',
                'prefix' => '',
                'zero_padding' => 0,
                'restriction_bankcash' => 5,
                'created_at' => date('Y-m-d H:i:s')                                  
            ]
        );

       

    }
}
