<?php
namespace App\Http\Controllers\API;

use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\AppBaseController;
use Response;
use App\Http\Resources\User\UserResource;
use Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Log;
use Carbon\Carbon;
use App\Repositories\QualityCheckRepository;
/**
 * Class DemoController
 * @package App\Http\Controllers\API
 */

class QualityCheckAPIController extends AppBaseController
{
    /** @var  BondRecipeProductionRepository */
    private $qualityCheckRepo;

    public function __construct(QualityCheckRepository $qualityCheckRepo)
    {
        $this->qualityCheckRepo = $qualityCheckRepo;
    }

    public function listQualityCheck(Request $request){
        $query = $request->get('query');
        $bondMaterialRecipe=null;
        $user = Auth::user();
        if ($user->hasPermission('limitlist.qualitychecks')) { // you can pass an id or slug
            $bondMaterialRecipe = \App\Models\QualityCheck::orderBy('created_at','DESC')->where('created_by',$user->id)->take(config('app_data.limit_list_count'))->get();
            return  new \App\Http\Resources\LimitlistPaginationResourceCollection($bondMaterialRecipe, \App\Http\Resources\Production\QualityCheckResource::class);      
        }else if($user->hasPermission('list.qualitychecks')){
            if(!empty($query)){
                $bondMaterialRecipe = \App\Models\QualityCheck::where('material_id','like','%'.$query.'%')->orderBy('created_at','DESC')->paginate(config('app_data.per_page_data'));
            }else{
                $bondMaterialRecipe = \App\Models\QualityCheck::orderBy('created_at','DESC')->paginate(config('app_data.per_page_data'));
            }
        }else{
            return $this->sendValidationError('Access denied, please contact to admin');
        }

        return  new \App\Http\Resources\BasePaginationResourceCollection($bondMaterialRecipe, collect($bondMaterialRecipe->items()), \App\Http\Resources\Production\QualityCheckResource::class);
    }

}

