<?php 

namespace App\Http\Resources\Consumable;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Models\User;
use App\Http\Resources\BaseJsonResource;

class ConsumableItemResource extends BaseJsonResource
{
    public function toArray($request)
    {

        $array = [
            'id' => $this->id,
            'name' => $this->name,
            'spec' => $this->spec,
            'add_spec' => $this->add_spec,
            'weight' => $this->weight,
            'description' => $this->description,
            'opening_stock' => $this->opening_stock,
            'unit_price' => $this->unit_price,
            'opening_stock_unit' => $this->unit->alias,
            'category' => $this->category->name
        ];

        $array = $this->base($array);
        
        return $array;
    }
}