<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Translatable\HasTranslations;

/**
 * Class BinderComposition
 * @package App\Models
 * @version October 11, 2019, 9:25 pm UTC
 *
 */
class BinderComposition extends CRUDAwareModel
{
    use SoftDeletes;
    use HasTranslations;

    public $table = 'binder_compositions';
    

    protected $dates = ['deleted_at'];


    public $fillable = [
       'binder_name',
       'chem_name1',
       'chem_name2',
       'chem_name3',
       'chem_name4',
       'c1_percent',
       'c2_percent',
       'c3_percent',
       'c4_percent',
       'c1_percent',
       'price_per_litre'       
    ];

    public $translatable = ['binder_name','chem_name1','chem_name2','chem_name3','chem_name4'];


    
   
    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'binder_name.*' => 'required|unique_translation:binder_compositions',
        'c1_percent' => 'nullable|numeric|max:100',
        'c2_percent' => 'nullable|numeric|max:100',
        'c3_percent' => 'nullable|numeric|max:100',
        'c4_percent' => 'nullable|numeric|max:100',
        'price_per_litre' => 'nullable|numeric'
    ];

    public static $updateRules = [
        'binder_name.*' => 'required',
        'c1_percent' => 'nullable|numeric|max:100',
        'c2_percent' => 'nullable|numeric|max:100',
        'c3_percent' => 'nullable|numeric|max:100',
        'c4_percent' => 'nullable|numeric|max:100',
    ];

    
}
