<?php

namespace App\DataTables;

use App\Models\BinderComposition;
use Yajra\DataTables\Services\DataTable;
use Yajra\DataTables\EloquentDataTable;

class BinderCompositionDataTable extends DataTable
{
    /**
     * Build DataTable class.
     *
     * @param mixed $query Results from query() method.
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function dataTable($query)
    {
        $dataTable = new EloquentDataTable($query);

        $dataTable->addColumn('name', function (BinderComposition $album) {
            return $album->getTranslations('binder_name')['en'];
        });

        $dataTable->addColumn('chemical1', function (BinderComposition $album) {
            return $album->chem_name1.' '.$album->c1_percent.'%';
        });

        $dataTable->addColumn('chemical2', function (BinderComposition $album) {
            return $album->chem_name2.' '.$album->c2_percent.'%';
        });

        $dataTable->addColumn('chemical3', function (BinderComposition $album) {
            return $album->chem_name3.' '.$album->c3_percent.'%';
        });

        $dataTable->addColumn('chemical4', function (BinderComposition $album) {
            return empty($album->chem_name4)?'':$album->chem_name4.' '.$album->c4_percent.'%';
        });

        $dataTable->filterColumn('name', function($query, $keyword) {
            //Log::info('filter col name '.$keyword);
            $keyword = strtolower($keyword);
            $query->whereRaw('LOWER(JSON_EXTRACT(binder_name,"$.en")) LIKE ?', ["%{$keyword}%"]);
        });

        $dataTable->filterColumn('chemical1', function($query, $keyword) {
            //Log::info('filter col name '.$keyword);
            $keyword = strtolower($keyword);
            $query->whereRaw('LOWER(JSON_EXTRACT(chem_name1,"$.en")) LIKE ?', ["%{$keyword}%"]);
        });

        $dataTable->filterColumn('chemical2', function($query, $keyword) {
            //Log::info('filter col name '.$keyword);
            $keyword = strtolower($keyword);
            $query->whereRaw('LOWER(JSON_EXTRACT(chem_name2,"$.en")) LIKE ?', ["%{$keyword}%"]);
        });


        $dataTable->filterColumn('chemical3', function($query, $keyword) {
            //Log::info('filter col name '.$keyword);
            $keyword = strtolower($keyword);
            $query->whereRaw('LOWER(JSON_EXTRACT(chem_name3,"$.en")) LIKE ?', ["%{$keyword}%"]);
        });

        $dataTable->filterColumn('chemical4', function($query, $keyword) {
            //Log::info('filter col name '.$keyword);
            $keyword = strtolower($keyword);
            $query->whereRaw('LOWER(JSON_EXTRACT(chem_name4,"$.en")) LIKE ?', ["%{$keyword}%"]);
        });


        return $dataTable->addColumn('action', 'binder_compositions.datatables_actions');
    }

    /**
     * Get query source of dataTable.
     *
     * @param \App\Models\BinderComposition $model
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query(BinderComposition $model)
    {
        return $model->newQuery();
    }

    /**
     * Optional method if you want to use html builder.
     *
     * @return \Yajra\DataTables\Html\Builder
     */
    public function html()
    {
        return $this->builder()
            ->columns($this->getColumns())
            ->minifiedAjax()
            ->addAction(['width' => '120px', 'printable' => false])
            ->parameters([
                'dom'       => 'Bfrtip',
                'stateSave' => true,
                'order'     => [[0, 'desc']],
                'buttons'   => [
                    ['extend' => 'create', 'className' => 'btn btn-default btn-sm no-corner',],
                    ['extend' => 'export', 'className' => 'btn btn-default btn-sm no-corner',],
                    ['extend' => 'print', 'className' => 'btn btn-default btn-sm no-corner',],
                    ['extend' => 'reset', 'className' => 'btn btn-default btn-sm no-corner',],
                    ['extend' => 'reload', 'className' => 'btn btn-default btn-sm no-corner',],
                ],
            ]);
    }

    /**
     * Get columns.
     *
     * @return array
     */
    protected function getColumns()
    {
        return [
            'name',
            'chemical1' => ['searchable' => false],
            'chemical2' => ['searchable' => true],
            'chemical3' => ['searchable' => true],
            'chemical4' => ['searchable' => true],
                 
        ];
    }

    /**
     * Get filename for export.
     *
     * @return string
     */
    protected function filename()
    {
        return 'binder_compositionsdatatable_' . time();
    }
}
