<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Translatable\HasTranslations;

/**
 * Class BondProcessParams
 * @package App\Models
 * @version October 11, 2019, 8:26 pm UTC
 *
 */
class BondProcessParams extends CRUDAwareModel
{
    //use SoftDeletes;
    use HasTranslations;

    public $table = 'bond_process_params';
    

    protected $dates = ['deleted_at'];


    public $fillable = [
        'name',
        'mixing_detail',
        'proc_type',
        'design_detail',
        'hotpress_detail',
        'finishing_detail',
        'other_detail',
        'bond_design_id',
        'cycle_time',
        'expected_mould'
    ];

    public $translatable = ['mixing_detail','design_detail','hotpress_detail','finishing_detail','other_detail'];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        "cycle_time" => "float",
        "expected_mould" => "float"
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'name' => 'required|unique:bond_process_params',
        'consumable_settings' => 'required|exists:consumable_settings,id',
        'cycle_time' => 'nullable|numeric',
        'expected_mould' => 'required|numeric'
    ];

    public function consumableSettings(){
        return $this->belongsToMany('App\Models\ConsumableSettings', 'bond_process_consumable', 'bond_process_id', 'consumable_settings_id');
    } 
    

    public function binderSetting(){
        $settings = $this->consumableSettings()->get();
        
    }

    public function findSetting($type){
        $settings = $this->consumableSettings;
        foreach($settings as $setting){
            if($setting->type == $type){
                return $setting;
            }
        }
        return null;
    }
}
