<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class BondProduct
 * @package App\Models
 * @version January 3, 2020, 5:51 am UTC
 *
 */
class BondProduct extends Model
{
    //use SoftDeletes;

    public $table = 'bond_products';
    

    protected $dates = ['deleted_at'];


    public $fillable = [
       'name',
       'name_print',
       'bond_id',
       'bond_design_id',
       'opening_stock',
       'qty_unit_id',
       'bond_type_id',
       'hsn_code',
       'category'  
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        "opening_stock" => "float"
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'bond' => 'required|exists:bonds,id',
        'bond_design' => 'required|exists:bond_designs,id',
        'unit' => 'required|exists:units,id',
        'opening_stock' => 'nullable'
    ];

    public function design(){
        return $this->belongsTo('App\Models\BondDesign','bond_design_id');
    } 

    public function bond(){
        return $this->belongsTo('App\Models\Bond','bond_id');
    }

    public function type(){
        return $this->belongsTo('App\Models\BondProductType','bond_type_id');
    }

    public function unit()
    {
        return $this->belongsTo('App\Models\Unit','qty_unit_id');
    }
    
}
