<?php

use Illuminate\Database\Seeder;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class AccountGroupSeeder extends Seeder
{
    private $tableName;

    public function __construct()
    {
        $this->tableName = 'account_groups';
    }

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table($this->tableName)->insert(
            [
                'id' => 1,                                
                'name' => 'Assets',
                'code' => NULL,
                'affects_gross' => 0,
                'created_by' => 1,
                'created_at' => date('Y-m-d H:i:s')                                  
            ]
        );

        DB::table($this->tableName)->insert(
            [
                'id' => 2,                                
                'name' => 'Liabilities and Owners Equity',
                'code' => NULL,
                'affects_gross' => 0,
                'created_by' => 1,
                'created_at' => date('Y-m-d H:i:s')                 
            ]
        );
        
        DB::table($this->tableName)->insert(
            [
                'id' => 3,                               
                'name' => 'Incomes',
                'code' => NULL,
                'affects_gross' => 0,
                'created_by' => 1,
                'created_at' => date('Y-m-d H:i:s')                 
            ]
        );

        DB::table($this->tableName)->insert(
            [
                'id' => 4,                                
                'name' => 'Expenses',
                'code' => NULL,
                'affects_gross' => 0,
                'created_by' => 1,
                'created_at' => date('Y-m-d H:i:s')                 
            ]
        );

        DB::table($this->tableName)->insert(
            [
                'id' => 5,
                'parent_id' => 1,                
                'name' => 'Fixed Assets',
                'code' => NULL,
                'affects_gross' => 0,
                'created_by' => 1,
                'created_at' => date('Y-m-d H:i:s')                 
            ]
        );

        DB::table($this->tableName)->insert(
            [
                'id' => 6,
                'parent_id' => 1,                
                'name' => 'Current Assets',
                'code' => NULL,
                'affects_gross' => 0,
                'created_by' => 1,
                'created_at' => date('Y-m-d H:i:s')                 
            ]
        );

        DB::table($this->tableName)->insert(
            [
                'id' => 7,
                'parent_id' => 1,                
                'name' => 'Investments',
                'code' => NULL,
                'affects_gross' => 0,
                'created_by' => 1,
                'created_at' => date('Y-m-d H:i:s')                 
            ]
        );

        DB::table($this->tableName)->insert(
            [
                'id' => 8,
                'parent_id' => 2,                
                'name' => 'Capital Account',
                'code' => NULL,
                'affects_gross' => 0,
                'created_by' => 1,
                'created_at' => date('Y-m-d H:i:s')                 
            ]
        );

        DB::table($this->tableName)->insert(
            [
                'id' => 9,
                'parent_id' => 2,                
                'name' => 'Current Liabilities',
                'code' => NULL,
                'affects_gross' => 0,
                'created_by' => 1,
                'created_at' => date('Y-m-d H:i:s')                 
            ]
        );

        DB::table($this->tableName)->insert(
            [
                'id' => 10,
                'parent_id' => 2,                
                'name' => 'Loans (Liabilities)',
                'code' => NULL,
                'affects_gross' => 0,
                'created_by' => 1,
                'created_at' => date('Y-m-d H:i:s')                 
            ]
        );

        DB::table($this->tableName)->insert(
            [
                'id' => 11,
                'parent_id' => 3,                
                'name' => 'Direct Incomes',
                'code' => NULL,
                'affects_gross' => 1,
                'created_by' => 1,
                'created_at' => date('Y-m-d H:i:s')                 
            ]
        );

        DB::table($this->tableName)->insert(
            [
                'id' => 12,
                'parent_id' => 4,                
                'name' => 'Direct Expenses',
                'code' => NULL,
                'affects_gross' => 1,
                'created_by' => 1,
                'created_at' => date('Y-m-d H:i:s')                 
            ]
        );

		 DB::table($this->tableName)->insert(
            [
                'id' => 17,
                'parent_id' => 12,                
                'name' => 'Salary & Wages',
                'code' => NULL,
                'affects_gross' => 1,
                'created_by' => 1,
                'created_at' => date('Y-m-d H:i:s')                 
            ]
        );

		
        DB::table($this->tableName)->insert(
            [
                'id' => 13,
                'parent_id' => 3,                
                'name' => 'Indirect Incomes',
                'code' => NULL,
                'affects_gross' => 0,
                'created_by' => 1,
                'created_at' => date('Y-m-d H:i:s')                 
            ]
        );

        DB::table($this->tableName)->insert(
            [
                'id' => 14,
                'parent_id' => 4,                
                'name' => 'Indirect Expenses',
                'code' => NULL,
                'affects_gross' => 0,
                'created_by' => 1,
                'created_at' => date('Y-m-d H:i:s')                 
            ]
        );

        DB::table($this->tableName)->insert(
            [
                'id' => 15,
                'parent_id' => 3,                
                'name' => 'Sales',
                'code' => NULL,
                'affects_gross' => 0,
                'created_by' => 1,
                'created_at' => date('Y-m-d H:i:s')                 
            ]
        );

        DB::table($this->tableName)->insert(
            [
                'id' => 16,
                'parent_id' => 4,                
                'name' => 'Purchases',
                'code' => NULL,
                'affects_gross' => 0,
                'created_by' => 1,
                'created_at' => date('Y-m-d H:i:s')                 
            ]
        );


        DB::table($this->tableName)->insert(
            [
                'id' => 18,
                'parent_id' => 16,                
                'name' => 'Die',
                'code' => NULL,
                'affects_gross' => 0,
                'created_by' => 1,
                'created_at' => date('Y-m-d H:i:s')                 
            ]
        );

        DB::table($this->tableName)->insert(
            [
                'id' => 19,
                'parent_id' => 16,                
                'name' => 'Punch',
                'code' => NULL,
                'affects_gross' => 0,
                'created_by' => 1,
                'created_at' => date('Y-m-d H:i:s')                 
            ]
        );


        DB::table($this->tableName)->insert(
            [
                'id' => 20,
                'parent_id' => 16,                
                'name' => 'Patti',
                'code' => NULL,
                'affects_gross' => 0,
                'created_by' => 1,
                'created_at' => date('Y-m-d H:i:s')                 
            ]
        );

        DB::table($this->tableName)->insert(
            [
                'id' => 21,
                'parent_id' => 16,                
                'name' => 'Binder & Chemical',
                'code' => NULL,
                'affects_gross' => 0,
                'created_by' => 1,
                'created_at' => date('Y-m-d H:i:s')                 
            ]
        );

        DB::table($this->tableName)->insert(
            [
                'id' => 22,
                'parent_id' => 16,                
                'name' => 'Metal Powder',
                'code' => NULL,
                'affects_gross' => 0,
                'created_by' => 1,
                'created_at' => date('Y-m-d H:i:s')                 
            ]
        );

        DB::table($this->tableName)->insert(
            [
                'id' => 23,
                'parent_id' => 16,                
                'name' => 'Diamond Powder',
                'code' => NULL,
                'affects_gross' => 0,
                'created_by' => 1,
                'created_at' => date('Y-m-d H:i:s')                 
            ]
        );

        DB::table($this->tableName)->insert(
            [
                'id' => 24,
                'parent_id' => 16,                
                'name' => 'Machine Accessories',
                'code' => NULL,
                'affects_gross' => 0,
                'created_by' => 1,
                'created_at' => date('Y-m-d H:i:s')                 
            ]
        );

    }
}
