<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Log;
use Illuminate\Support\Facades\DB;


/**
 * Class AccountGroup
 * @package App\Models
 * @version November 18, 2019, 6:45 pm UTC
 *
 * @property \Illuminate\Database\Eloquent\Collection userRoles
 * @property string bond_name
 * @property string bond_short_description
 * @property string phone
 * @property string username
 * @property string email
 * @property string password
 * @property string device_id
 * @property string location
 * @property string profile_path
 * @property string dob
 * @property string status
 */
class AccountGroup extends CRUDAwareModel
{

    public $table = 'account_groups';
    

    protected $dates = ['deleted_at'];


    public $fillable = [
        'name',
        'code',
        'affects_gross'
    ];

    public $children = array();

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'name' => 'required|unique:account_groups',
        'code' => 'nullable|unique:account_groups',
        'parent_group' => ''
    ];


    public function childs() {
        return $this->hasMany('App\Models\AccountGroup','parent_id','id') ;
    }

    public function allChilds() {
        return $this->hasMany('App\Models\AccountGroup','parent_id','id')->with('allChilds');
    }

    public function parent()
    {
        return $this->belongsTo('App\Models\AccountGroup', 'parent_id');
    }

    public function crTotal(){
        return DB::table('account_total_view')->groupBy('account_group')->having('account_group','=', $this->name)->pluck('cr_total');
    }

    public function drTotal(){
        return DB::table('account_total_view')->groupBy('account_group')->having('account_group','=', $this->name)->pluck('dr_total');
    }

   var $arrayList = array();

    public function getChildNameArray(){
        $childs = AccountGroup::where('parent_id','=',null)->orderBy('id', "asc")->get();
        
        foreach ($childs as $row)
		{
            Log::info("name ".$row->name);
			self::getChildTree( $row);
        }
        return $this->arrayList;
    }

    private function getChildTree($node, $c=0){
       $this->arrayList[$node->id] = $this->space($c) .
       self::toCodeWithName($node->code, $node->name);

       Log::info("name ".$this->arrayList[$node->id]);

       $childs = $node->childs()->get();
		foreach ($childs as $row)
		{
			$this->getChildTree( $row, $c+1);
        }
       // dd( $arrayList);
    }

	static function  space($count)
	{
		$str = '';
		for ($i = 1; $i <= $count; $i++) {
			$str .= '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
		}
		return $str;
    }
    
    public static function toCodeWithName($code, $name) {
        if (strlen($code) <= 0) {
            return $name;
        } else {
            return '[' . $code . '] ' . $name;
        }
    }

}
