@section('css')
    @include('layouts.datatables_css')
@endsection


<div class="form-row">
        <div class="form-group col-sm-4">
                {!! BootForm::text('Consumable Settings Name', 'name')->placeholder('Consumable Settings Name')->attribute('disabled', 'true')   !!}		 
        </div>
        <div class="form-group col-sm-4">
                {!! BootForm::text('Consumable Settings Description', 'description')->placeholder('Consumable Settings Description')->attribute('disabled', 'true')   !!}		
        </div>
        <div class="form-group col-sm-4">
                {!! BootForm::select('Type', 'type')->options(['DIE' => 'DIE', 'PATTI' => 'PATTI', 'MOULD' => 'MOULD', 'GRINDING' => 'GRINDING', 'FINISHING' => 'FINISHING', 'HOT_PRESS' => 'HOT_PRESS', 'COLD_PRESS' => 'COLD_PRESS', 'BINDER' => 'BINDER', 'OTHER' => 'OTHER'])->attribute('disabled', 'true');   !!}		 
        </div>
</div>


<div class="form-row">
<div class="form-group col-sm-12">
<table cellpadding="0" cellspacing="0" border="0" class="dataTable table table-striped" id="dataInputTable">
</table>
</div>
</div>

<!-- Submit Field -->
<div class="form-group col-sm-12">
    {!! Form::submit('Save', ['class' => 'btn btn-primary']) !!}
    <a href="{!! route('consumableSettings.index') !!}" class="btn btn-default">Cancel</a>
</div>

@section('scripts')
    @include('layouts.datatables_js')
@endsection

@push('scripts')
<script>
$(document).ready(function() {

    var dataSet = [
     
    ];

    var settingId = {{ $settings->id }};

    var countryOptions = [  {!! '"'.implode('","',  $categories ).'"' !!} ];

    var qtyType = ['PERCENTAGE', 'UNIT'];
    
  
    var columnDefs = [
        {
    data: "id",
    title: "Id",
    type: "readonly"
  },
  {
      data: 'category',
      name:'category',
      title: "Consumable Categories",
      options : countryOptions,
      type : "select",
      select2 : { width: "100%"},
      editorOnChange : function(event, altEditor, dep) {
          console.log('hello 2122');
          console.log(event);
          console.log(dep);
        console.log(event);
        var category = $(event.currentTarget).val();
        /*
        In a real world application, this should just call a single webservice,
        passing rowdatata.country as argument
        */
        console.log('cat '+category);
        if(category!=''){
            $(altEditor.modal_selector).find("#alteditor-row-item").show();
            $.ajax({
                url: "{{env('APP_URL')}}" + "/admin/api/consumable_items/"+ encodeURIComponent(category),
                type: 'GET',
                success: function(options) {
                    console.log('hello '+options);
                    var town = $(altEditor.modal_selector).find('#item');
                    altEditor.reloadCustomOptions(town, (options));
                }
            });
        }else{
            $(altEditor.modal_selector).find("#alteditor-row-item").hide();
        }
         
    }

    }, {
      title: "Consumable Item Name",
      data:'item',
      type : "select",
      dependent:true,
      select2 : { width: "100%"}
    }, {
      title: "Qty",
      data:'qty',
    },
    {
      title: "Qty Type",
      data:'qty_type',
      options : qtyType,
      type : "select",
      select2 : { width: "100%"},
    },
    {
      title: "Expected Pcs",
      data:'expected_pcs',
    }];
  
    var myTable;
  
    myTable = $('#dataInputTable').DataTable({
      "sPaginationType": "full_numbers",
      ajax: {
        url : "{{env('APP_URL')}}" + "/admin/consumableSettings/getSettings/"+settingId,
        // our data is an array of objects, in the root node instead of /data node, so we need 'dataSrc' parameter
        dataSrc : ''
    },
      columns: columnDefs,
          dom: 'Bfrtip',        // Needs button container
            select: 'single',
            responsive: true,
            altEditor: true,     // Enable altEditor
            buttons: [{
              text: 'Add',
              name: 'add'        // do not change name
            },
            {
              extend: 'selected', // Bind to Selected row
              text: 'Edit',
              name: 'edit'        // do not change name
            },
            {
              extend: 'selected', // Bind to Selected row
              text: 'Delete',
              name: 'delete'      // do not change name
           }],
        onAddRow: function(datatable, rowdata, success, error) {
            rowdata['_token'] = "{{ csrf_token() }}";

            $.ajax({
                // a tipycal url would be / with type='PUT'
                url: "{{env('APP_URL')}}" + "/admin/consumableSettings/saveSettings/"+settingId,
                type: 'POST',
                data: rowdata,
                success: success,
                error: error
            });
        },
        onDeleteRow: function(datatable, rowdata, success, error) {
            rowdata['_token'] = "{{ csrf_token() }}";
            $.ajax({
                // a tipycal url would be /{id} with type='DELETE'
                url: "{{env('APP_URL')}}" + "/admin/consumableSettings/deleteSettings/"+settingId,
                type: 'POST',
                data: rowdata,
                success: success,
                error: error
            });
        },
        onEditRow: function(datatable, rowdata, success, error) {
            rowdata['_token'] = "{{ csrf_token() }}";
            $.ajax({
                // a tipycal url would be /{id} with type='POST'
                url: "{{env('APP_URL')}}" + "/admin/consumableSettings/updateSettings/"+settingId,
                type: 'POST',
                data: rowdata,
                success: success,
                error: error
            });
        }
    });
  
  
  });
  </script>
@endpush