<?php 

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\Mini\MiniAttachmentResource;

class BaseJsonResource extends JsonResource
{
    public static function customCollection($objects){
        return static::collection($objects)->additional([
            'success' => 'true'
        ]);    
    }

    public function hNull($amt){
        if(!isset($amt)){
            return 0;
        }
        return $amt;
    }

    public function withAd(){
       $this->additional([
        'success' => 'true'
    ]);
    return $this;    

    }

    public function base($array){

        $array['created_at'] = ResourceHelper::formatDate($this->created_at);
        $array['updated_at'] = ResourceHelper::formatDate($this->updated_at);
        if(isset($this->created_by)){
            if(isset($this->createdBy)){
                $array['created_by'] = $this->createdBy->name;
            }
            
        }
        if(isset($this->updated_by)){
            if(isset($this->updatedBy)){
                $array['updated_by'] = $this->updatedBy->name;
            }
        }

        
        //$array['created_by'] = $this->createdBy->name;
        return $array;
    }
}