<?php 

namespace App\Http\Resources\Bond;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\BaseJsonResource;

class BondProductResource extends BaseJsonResource
{
    public function toArray($request)
    {

        $array = [
            'id' => $this->id,
            'name' => $this->name,
            'name_print' => $this->name_print,
            'bond' => new BondResource($this->bond),
            'bond_design' => new BondDesignResource($this->design),
            'qty_unit' => $this->unit->alias,
            'opening_stock' => $this->opening_stock,
        ];

        $array = $this->base($array);
        
        return $array;
    }
}