<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class ConsumableConsumpation
 * @package App\Models
 * @version December 19, 2019, 4:40 am UTC
 *
 */
class ConsumableConsumpationDetail extends Model
{
    public $table = 'consumable_consumpation_details';
    

    protected $dates = ['created_at'];


    public $fillable = [
        'consumpation_id',
        'consumable_id',
        'qty',
        'consumed_percentage',
        'created_by',
        'updated_by'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'qty' => 'float',
        'consumed_percentage' => 'float',
        
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        
    ];

    public function consumable()
    {
        return $this->belongsTo('App\Models\ConsumableItem','consumable_id');
    }
}
