<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Entry
 * @package App\Models
 * @version November 26, 2019, 3:52 am UTC
 *
 */
class InvoiceConsumableDetail extends Model
{
    //use SoftDeletes;

    public $table = 'invoice_consumable_detail';
    

    protected $dates = ['deleted_at'];


    public $fillable = [
        'invoice_id',
        'consumable_id',
        'qty',
        'unit_price',
        'amount',
        'cgst',
        'sgst',
        'igst',
        'cgst_value',
        'sgst_value',
        'igst_value',
        'discount',
        'discount_val',
        'net_gst',
        'net_amount'          
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'qty' => 'float',
        'unit_price' => 'float',
        'amount' => 'float',
        'cgst' => 'float',
        'sgst' => 'float',
        'igst' => 'float',
        'cgst_value' => 'float',
        'sgst_value' => 'float',
        'igst_value' => 'float',
        'discount' => 'float',
        'discount_val' => 'float'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        
    ];

    public function consumableItem(){
        return $this->hasOne('App\Models\ConsumableItem','id','consumable_id');
    }

    
}
