<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProductionPackagingDetails extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('production_packaging_detail', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('packing_id')->unique();
            $table->unsignedBigInteger('material_id');
            $table->decimal('qty', 25, 2);
            $table->timestamps();

            $table->unsignedBigInteger('created_by')->nullable(false);
            $table->unsignedBigInteger('updated_by')->nullable();
            //$table->unsignedBigInteger('deleted_by')->nullable();
            $table->foreign('created_by')->references('id')->on('users');
            $table->foreign('updated_by')->references('id')->on('users');        
            //$table->foreign('deleted_by')->references('id')->on('users');  

            $table->foreign('packing_id')->references('packing_id')->on('production_packagings')->onDelete('cascade');
            $table->foreign('material_id')->references('material_id')->on('bond_recipe_productions')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('production_packaging_detail');
    }
}
