<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateConsumableDetail extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('consumable_details', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->timestamps();
            //$table->softDeletes();
            
            $table->unsignedBigInteger('consumable_id')->nullable(true);
            $table->unsignedBigInteger('item_id');
            $table->decimal('qty')->nullable(true);
            $table->enum('qty_type', ['PERCENTAGE','UNIT'])->nullable(true);
            $table->decimal('expected_pcs', 25, 2)->nullable(true);

            $table->foreign('consumable_id')->references('id')->on('consumable_settings')->onDelete('cascade');
        });        
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mould_details');
    }
}
